/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.module.coverage;

import org.simantics.scl.compiler.module.coverage.Coverage;
import org.simantics.scl.compiler.module.coverage.CoverageUtils;

public abstract class AbstractCoverage
implements Coverage {
    private String identifier;
    private final int totalCodeSize;
    private final int coveredCodeSize;
    private final double coverage;

    public AbstractCoverage(String identifier, int totalCodeSize, int coveredCodeSize) {
        this.identifier = identifier;
        this.coverage = CoverageUtils.safeDiv(coveredCodeSize, totalCodeSize);
        this.totalCodeSize = totalCodeSize;
        this.coveredCodeSize = coveredCodeSize;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public double getCoverage() {
        return this.coverage;
    }

    @Override
    public int getTotalCodeSize() {
        return this.totalCodeSize;
    }

    @Override
    public int getCoveredCodeSize() {
        return this.coveredCodeSize;
    }

    @Override
    public int getMissedCodeSize() {
        return this.totalCodeSize - this.coveredCodeSize;
    }

    String toPercent(double v) {
        return String.valueOf(String.valueOf(v * 100.0)) + "%";
    }
}

