/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.utils;

import org.cojen.classfile.MethodDesc;
import org.cojen.classfile.TypeDesc;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.simantics.scl.compiler.internal.codegen.utils.ClassBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.Constants;
import org.simantics.scl.compiler.internal.codegen.utils.LocalVariable;

public class MethodBuilderBase {
    private ClassBuilder classBuilder;
    private MethodVisitor methodVisitor;
    private LocalVariable[] parameters;
    private int localVariableCount = 0;
    private int currentLineNumber = -1;

    public MethodBuilderBase(ClassBuilder classBuilder, boolean isStatic, MethodVisitor methodVisitor, TypeDesc[] parameterTypes) {
        this.classBuilder = classBuilder;
        this.methodVisitor = methodVisitor;
        this.parameters = new LocalVariable[parameterTypes.length];
        if (!isStatic) {
            ++this.localVariableCount;
        }
        int i = 0;
        while (i < parameterTypes.length) {
            this.parameters[i] = this.createLocalVariable("p" + i, parameterTypes[i]);
            methodVisitor.visitParameter("p" + i, 1);
            ++i;
        }
        methodVisitor.visitCode();
    }

    public LocalVariable getThis(TypeDesc type) {
        return new LocalVariable(0, type);
    }

    public void loadConstant(boolean value) {
        if (value) {
            this.methodVisitor.visitInsn(4);
        } else {
            this.methodVisitor.visitInsn(3);
        }
    }

    public void loadConstant(int value) {
        if (value >= -1 && value <= 5) {
            this.methodVisitor.visitInsn(3 + value);
        } else if (value >= -128 && value <= 127) {
            this.methodVisitor.visitIntInsn(16, value);
        } else if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            this.methodVisitor.visitIntInsn(17, value);
        } else {
            this.methodVisitor.visitLdcInsn((Object)value);
        }
    }

    public void loadConstant(long value) {
        if (value == 0L) {
            this.methodVisitor.visitInsn(9);
        } else if (value == 1L) {
            this.methodVisitor.visitInsn(10);
        } else {
            this.methodVisitor.visitLdcInsn((Object)value);
        }
    }

    public void loadConstant(float value) {
        if (value == 0.0f) {
            this.methodVisitor.visitInsn(11);
        } else if (value == 1.0f) {
            this.methodVisitor.visitInsn(12);
        } else {
            this.methodVisitor.visitLdcInsn((Object)Float.valueOf(value));
        }
    }

    public void loadConstant(double value) {
        if (value == 0.0) {
            this.methodVisitor.visitInsn(14);
        } else if (value == 1.0) {
            this.methodVisitor.visitInsn(15);
        } else {
            this.methodVisitor.visitLdcInsn((Object)value);
        }
    }

    public void loadConstant(String value) {
        this.methodVisitor.visitLdcInsn((Object)value);
    }

    public void loadConstant(TypeDesc value) {
        if (value.isPrimitive()) {
            this.loadStaticField(MethodBuilderBase.getClassName(value.toObjectType()), "TYPE", Constants.CLASS);
        } else {
            this.methodVisitor.visitLdcInsn((Object)Type.getType((String)value.getDescriptor()));
        }
    }

    public int lineNumber(int lineNumber) {
        if (lineNumber != this.currentLineNumber) {
            int oldLineNumber = this.currentLineNumber;
            Label label = this.createLabel();
            this.setLocation(label);
            this.methodVisitor.visitLineNumber(lineNumber, label);
            this.currentLineNumber = lineNumber;
            return oldLineNumber;
        }
        return this.currentLineNumber;
    }

    public void dup() {
        this.methodVisitor.visitInsn(89);
    }

    public void dup2() {
        this.methodVisitor.visitInsn(92);
    }

    public void dupX1() {
        this.methodVisitor.visitInsn(90);
    }

    public void swap() {
        this.methodVisitor.visitInsn(95);
    }

    public void pop() {
        this.methodVisitor.visitInsn(87);
    }

    public void pop2() {
        this.methodVisitor.visitInsn(88);
    }

    public void convert(TypeDesc fromType, TypeDesc toType) {
        switch (fromType.getTypeCode() + 16 * toType.getTypeCode()) {
            case 64: {
                this.methodVisitor.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
                return;
            }
            case 160: {
                this.methodVisitor.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
                return;
            }
            case 96: {
                this.methodVisitor.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F", false);
                return;
            }
            case 112: {
                this.methodVisitor.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D", false);
                return;
            }
            case 80: {
                this.methodVisitor.visitMethodInsn(182, "java/lang/Character", "charValue", "()C", false);
                return;
            }
            case 176: {
                this.methodVisitor.visitMethodInsn(182, "java/lang/Long", "longValue", "()J", false);
                return;
            }
            case 144: {
                this.methodVisitor.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S", false);
                return;
            }
            case 128: {
                this.methodVisitor.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B", false);
                return;
            }
            case 103: {
                this.methodVisitor.visitInsn(144);
                return;
            }
            case 118: {
                this.methodVisitor.visitInsn(141);
                return;
            }
            case 122: {
                this.methodVisitor.visitInsn(135);
                return;
            }
            case 167: {
                this.methodVisitor.visitInsn(142);
                return;
            }
            case 106: {
                this.methodVisitor.visitInsn(134);
                return;
            }
            case 166: {
                this.methodVisitor.visitInsn(139);
                return;
            }
            case 107: {
                this.methodVisitor.visitInsn(137);
                return;
            }
            case 182: {
                this.methodVisitor.visitInsn(140);
                return;
            }
            case 123: {
                this.methodVisitor.visitInsn(138);
                return;
            }
            case 183: {
                this.methodVisitor.visitInsn(143);
                return;
            }
            case 186: {
                this.methodVisitor.visitInsn(133);
                return;
            }
            case 171: {
                this.methodVisitor.visitInsn(136);
                return;
            }
            case 154: {
                this.methodVisitor.visitInsn(147);
                return;
            }
            case 164: 
            case 169: {
                return;
            }
            case 138: {
                this.methodVisitor.visitInsn(145);
                return;
            }
            case 168: {
                return;
            }
            case 90: {
                this.methodVisitor.visitInsn(146);
                return;
            }
            case 165: {
                return;
            }
        }
        System.out.println("convert: " + fromType + " -> " + toType);
    }

    public void convert(TypeDesc fromType, TypeDesc toType, int convertFpNormal) {
        this.convert(fromType, toType);
    }

    public LocalVariable createLocalVariable(String name, TypeDesc type) {
        int index = this.localVariableCount;
        this.localVariableCount += type == TypeDesc.DOUBLE || type == TypeDesc.LONG ? 2 : 1;
        return new LocalVariable(index, type);
    }

    public void storeLocal(LocalVariable local) {
        switch (local.type.getTypeCode()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                this.methodVisitor.visitVarInsn(54, local.index);
                break;
            }
            case 6: {
                this.methodVisitor.visitVarInsn(56, local.index);
                break;
            }
            case 7: {
                this.methodVisitor.visitVarInsn(57, local.index);
                break;
            }
            case 11: {
                this.methodVisitor.visitVarInsn(55, local.index);
                break;
            }
            case 0: {
                this.methodVisitor.visitVarInsn(58, local.index);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void ifZeroComparisonBranch(Label location, String choice) {
        int opcode;
        if (choice.equals("!=")) {
            opcode = 154;
        } else if (choice.equals("==")) {
            opcode = 153;
        } else if (choice.equals("<")) {
            opcode = 155;
        } else if (choice.equals(">")) {
            opcode = 157;
        } else if (choice.equals("<=")) {
            opcode = 158;
        } else if (choice.equals(">=")) {
            opcode = 156;
        } else {
            throw new IllegalArgumentException("Invalid choice \"" + choice + "\".");
        }
        this.methodVisitor.visitJumpInsn(opcode, location);
    }

    public void ifComparisonBranch(Label location, String choice, TypeDesc type) {
        switch (type.getTypeCode()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                int opcode;
                if (choice.equals("!=")) {
                    opcode = 160;
                } else if (choice.equals("==")) {
                    opcode = 159;
                } else if (choice.equals("<")) {
                    opcode = 161;
                } else if (choice.equals(">")) {
                    opcode = 163;
                } else if (choice.equals("<=")) {
                    opcode = 164;
                } else if (choice.equals(">=")) {
                    opcode = 162;
                } else {
                    throw new IllegalArgumentException("Invalid choice \"" + choice + "\".");
                }
                this.methodVisitor.visitJumpInsn(opcode, location);
                break;
            }
            case 6: {
                this.methodVisitor.visitInsn(149);
                this.ifZeroComparisonBranch(location, choice);
                break;
            }
            case 7: {
                this.methodVisitor.visitInsn(151);
                this.ifZeroComparisonBranch(location, choice);
                break;
            }
            case 11: {
                this.methodVisitor.visitInsn(148);
                this.ifZeroComparisonBranch(location, choice);
                break;
            }
            case 0: {
                int opcode;
                if (choice.equals("!=")) {
                    opcode = 166;
                } else if (choice.equals("==")) {
                    opcode = 165;
                } else {
                    throw new IllegalArgumentException("Invalid choice \"" + choice + "\".");
                }
                this.methodVisitor.visitJumpInsn(opcode, location);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void ifNullBranch(Label location, boolean choice) {
        this.methodVisitor.visitJumpInsn(choice ? 198 : 199, location);
    }

    public void branch(Label location) {
        this.methodVisitor.visitJumpInsn(167, location);
    }

    public Label createLabel() {
        return new Label();
    }

    public void setLocation(Label label) {
        this.methodVisitor.visitLabel(label);
    }

    public void loadLocal(LocalVariable local) {
        switch (local.type.getTypeCode()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                this.methodVisitor.visitVarInsn(21, local.index);
                break;
            }
            case 6: {
                this.methodVisitor.visitVarInsn(23, local.index);
                break;
            }
            case 7: {
                this.methodVisitor.visitVarInsn(24, local.index);
                break;
            }
            case 11: {
                this.methodVisitor.visitVarInsn(22, local.index);
                break;
            }
            case 0: {
                this.methodVisitor.visitVarInsn(25, local.index);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void loadNull() {
        this.methodVisitor.visitInsn(1);
    }

    public void loadFromArray(TypeDesc type) {
        switch (type.getTypeCode()) {
            case 4: {
                this.methodVisitor.visitInsn(51);
                break;
            }
            case 8: {
                this.methodVisitor.visitInsn(51);
                break;
            }
            case 5: {
                this.methodVisitor.visitInsn(52);
                break;
            }
            case 9: {
                this.methodVisitor.visitInsn(53);
                break;
            }
            case 10: {
                this.methodVisitor.visitInsn(46);
                break;
            }
            case 6: {
                this.methodVisitor.visitInsn(48);
                break;
            }
            case 7: {
                this.methodVisitor.visitInsn(49);
                break;
            }
            case 11: {
                this.methodVisitor.visitInsn(47);
                break;
            }
            case 0: {
                this.methodVisitor.visitInsn(50);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void invokeInterface(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        MethodBuilderBase.checkClassName(className);
        MethodBuilderBase.checkParameters(params);
        this.methodVisitor.visitMethodInsn(185, className, methodName, MethodDesc.forArguments(ret, params).getDescriptor(), true);
    }

    public void invokeInterface(TypeDesc className, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.invokeInterface(MethodBuilderBase.getClassName(className), methodName, ret, params);
    }

    public void invokeVirtual(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        MethodBuilderBase.checkClassName(className);
        MethodBuilderBase.checkParameters(params);
        this.methodVisitor.visitMethodInsn(182, className, methodName, MethodDesc.forArguments(ret, params).getDescriptor(), false);
    }

    public void invokeVirtual(TypeDesc className, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.invokeVirtual(MethodBuilderBase.getClassName(className), methodName, ret, params);
    }

    public void invokeConstructor(String className, TypeDesc[] params) {
        MethodBuilderBase.checkClassName(className);
        MethodBuilderBase.checkParameters(params);
        this.methodVisitor.visitMethodInsn(183, className, "<init>", MethodDesc.forArguments(TypeDesc.VOID, params).getDescriptor(), false);
    }

    public void invokeConstructor(TypeDesc className, TypeDesc[] params) {
        this.invokeConstructor(MethodBuilderBase.getClassName(className), params);
    }

    public void invokeSuperConstructor(TypeDesc[] params) {
        this.invokeConstructor(this.classBuilder.getSuperClassName(), params);
    }

    public void invokeStatic(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        MethodBuilderBase.checkClassName(className);
        MethodBuilderBase.checkParameters(params);
        this.methodVisitor.visitMethodInsn(184, className, methodName, MethodDesc.forArguments(ret, params).getDescriptor(), false);
    }

    public void invokeStatic(TypeDesc className, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.invokeStatic(MethodBuilderBase.getClassName(className), methodName, ret, params);
    }

    public void newObject(TypeDesc type) {
        this.methodVisitor.visitTypeInsn(187, MethodBuilderBase.getClassName(type));
    }

    public void newObject(String type) {
        this.methodVisitor.visitTypeInsn(187, type);
    }

    public void newObject(TypeDesc type, int dimensions) {
        this.methodVisitor.visitMultiANewArrayInsn(type.getDescriptor(), dimensions);
    }

    public void loadStaticField(String className, String fieldName, TypeDesc type) {
        MethodBuilderBase.checkClassName(className);
        this.methodVisitor.visitFieldInsn(178, className, fieldName, type.getDescriptor());
    }

    public void loadStaticField(TypeDesc className, String fieldName, TypeDesc type) {
        this.loadStaticField(MethodBuilderBase.getClassName(className), fieldName, type);
    }

    public void loadField(String className, String fieldName, TypeDesc type) {
        MethodBuilderBase.checkClassName(className);
        this.methodVisitor.visitFieldInsn(180, className, fieldName, type.getDescriptor());
    }

    public void storeStaticField(String className, String fieldName, TypeDesc type) {
        MethodBuilderBase.checkClassName(className);
        this.methodVisitor.visitFieldInsn(179, className, fieldName, type.getDescriptor());
    }

    public void storeField(String className, String fieldName, TypeDesc type) {
        MethodBuilderBase.checkClassName(className);
        this.methodVisitor.visitFieldInsn(181, className, fieldName, type.getDescriptor());
    }

    public void storeToArray(TypeDesc type) {
        switch (type.getTypeCode()) {
            case 4: {
                this.methodVisitor.visitInsn(84);
                break;
            }
            case 8: {
                this.methodVisitor.visitInsn(84);
                break;
            }
            case 5: {
                this.methodVisitor.visitInsn(85);
                break;
            }
            case 9: {
                this.methodVisitor.visitInsn(86);
                break;
            }
            case 10: {
                this.methodVisitor.visitInsn(79);
                break;
            }
            case 6: {
                this.methodVisitor.visitInsn(81);
                break;
            }
            case 7: {
                this.methodVisitor.visitInsn(82);
                break;
            }
            case 11: {
                this.methodVisitor.visitInsn(80);
                break;
            }
            case 0: {
                this.methodVisitor.visitInsn(83);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void math(int opcode) {
        this.methodVisitor.visitInsn(opcode);
    }

    public void throwObject() {
        this.methodVisitor.visitInsn(191);
    }

    public void checkCast(TypeDesc type) {
        this.methodVisitor.visitTypeInsn(192, MethodBuilderBase.getClassName(type));
    }

    public void instanceOf(TypeDesc type) {
        this.methodVisitor.visitTypeInsn(193, MethodBuilderBase.getClassName(type));
    }

    public void arrayLength() {
        this.methodVisitor.visitInsn(190);
    }

    public void loadThis() {
        this.methodVisitor.visitVarInsn(25, 0);
    }

    public LocalVariable getParameter(int index) {
        return this.parameters[index];
    }

    public void returnVoid() {
        this.methodVisitor.visitInsn(177);
    }

    public void returnValue(TypeDesc type) {
        switch (type.getTypeCode()) {
            case 1: {
                this.methodVisitor.visitInsn(177);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                this.methodVisitor.visitInsn(172);
                break;
            }
            case 6: {
                this.methodVisitor.visitInsn(174);
                break;
            }
            case 7: {
                this.methodVisitor.visitInsn(175);
                break;
            }
            case 11: {
                this.methodVisitor.visitInsn(173);
                break;
            }
            case 0: {
                this.methodVisitor.visitInsn(176);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void finish() {
        this.methodVisitor.visitMaxs(0, 0);
        this.methodVisitor.visitEnd();
    }

    public String getClassName() {
        return this.classBuilder.className;
    }

    public static String getClassName(TypeDesc typeDesc) {
        if (typeDesc.isArray()) {
            return typeDesc.getDescriptor();
        }
        return typeDesc.getFullName().replace('.', '/');
    }

    private static void checkClassName(String className) {
        ClassBuilder.checkClassName(className);
    }

    public static String getClassName(Class<?> clazz) {
        return clazz.getName().replace('.', '/');
    }

    public void switch_(int[] values, Label[] labels, Label defaultLabel) {
        int lo = values[0];
        int hi = values[values.length - 1];
        long table_space_cost = 4L + ((long)hi - (long)lo + 1L);
        long table_time_cost = 3L;
        long lookup_space_cost = 3L + 2L * (long)values.length;
        long lookup_time_cost = values.length;
        if (values.length > 0 && table_space_cost + 3L * table_time_cost <= lookup_space_cost + 3L * lookup_time_cost) {
            Label[] table = new Label[hi - lo + 1];
            int i = 0;
            int j = 0;
            while (i < table.length) {
                int id = lo + i;
                if (values[j] == id) {
                    table[i] = labels[j];
                    ++j;
                } else {
                    table[i] = defaultLabel;
                }
                ++i;
            }
            this.methodVisitor.visitTableSwitchInsn(lo, hi, defaultLabel, table);
        } else {
            this.methodVisitor.visitLookupSwitchInsn(defaultLabel, values, labels);
        }
    }

    private static void checkParameters(TypeDesc[] params) {
        TypeDesc[] typeDescArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            TypeDesc param = typeDescArray[n2];
            if (param.equals(TypeDesc.VOID)) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
    }
}

