/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.modelImport.model;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.modelImport.model.Connection;
import org.simantics.sysdyn.modelImport.model.Symbol;
import org.simantics.sysdyn.modelImport.model.WriteContext;

public class Dependency
extends Connection {
    private boolean showArrow;
    private boolean showDelay;
    private double angle;

    public Dependency() {
    }

    public Dependency(boolean showArrow, boolean showDelay, double angle) {
        this.showArrow = showArrow;
        this.showDelay = showDelay;
        this.angle = angle;
    }

    public Dependency(Symbol tail, Symbol head, boolean showArrow, boolean showDelay, double angle) {
        super(tail, head);
        this.showArrow = showArrow;
        this.showDelay = showDelay;
        this.angle = angle;
    }

    public boolean isShowArrow() {
        return this.showArrow;
    }

    public void setShowArrow(boolean showArrow) {
        this.showArrow = showArrow;
    }

    public boolean isShowDelay() {
        return this.showDelay;
    }

    public void setShowDelay(boolean showDelay) {
        this.showDelay = showDelay;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    @Override
    public Resource write(WriteGraph graph, Resource parent, WriteContext context) throws DatabaseException {
        if (this.getHead() == null || this.getTail() == null) {
            System.err.println("dependency missing head or tail");
            return null;
        }
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        Resource dependency = super.write(graph, parent, context);
        graph.claimLiteral(dependency, l0.HasName, (Object)context.getNextDependency(), (Binding)Bindings.STRING);
        graph.claimLiteral(this.getDiagramResource(), sr.Dependency_angle, (Object)this.angle, (Binding)Bindings.DOUBLE);
        return dependency;
    }

    @Override
    public Resource getConnectionType(ReadGraph graph) {
        return SysdynResource.getInstance((ReadGraph)graph).Dependency;
    }

    @Override
    public Resource getDiagramConnectionType(ReadGraph graph) {
        return SysdynResource.getInstance((ReadGraph)graph).DependencyConnection;
    }
}

