/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.structure;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.sysdyn.ui.structure.DependencyGraphRequest;
import org.simantics.sysdyn.ui.structure.StructureTabItem;

public class Dependencies
extends StructureTabItem {
    private boolean isInverted = false;
    private Button bButton;
    private Button fButton;
    private int levels = 3;
    private static int MAXLEVELS = 4;
    private static int MINLEVELS = 1;

    public Dependencies(CTabFolder parent, int style) {
        super(parent, style);
        Label line = new Label(this.structureComposite, 266);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)line);
        Composite composite = new Composite(this.structureComposite, 0);
        RowLayout layout = new RowLayout();
        layout.center = true;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText("Direction: ");
        this.bButton = new Button(composite, 16);
        this.bButton.setText("Backward");
        this.bButton.setSelection(true);
        this.bButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (Dependencies.this.bButton.getSelection()) {
                    Dependencies.this.isInverted = false;
                } else {
                    Dependencies.this.isInverted = true;
                }
                if (Dependencies.this.currentSelection != null) {
                    Dependencies.this.readGraph(Dependencies.this.currentSelection);
                }
            }
        });
        this.fButton = new Button(composite, 16);
        this.fButton.setText("Forward");
        label = new Label(composite, 0);
        label.setText("Steps: ");
        Spinner spinner = new Spinner(composite, 2048);
        spinner.setMaximum(MAXLEVELS);
        spinner.setMinimum(MINLEVELS);
        spinner.setTextLimit(1);
        spinner.setSelection(this.levels);
        spinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Spinner s = (Spinner)e.widget;
                int lvls = Integer.parseInt(s.getText());
                if (lvls > MAXLEVELS) {
                    Dependencies.this.levels = MAXLEVELS;
                } else if (lvls < MINLEVELS) {
                    Dependencies.this.levels = MINLEVELS;
                }
                Dependencies.this.levels = lvls;
                if (Dependencies.this.currentSelection != null) {
                    Dependencies.this.readGraph(Dependencies.this.currentSelection);
                }
            }
        });
        this.setText("Dependencies");
        this.setControl((Control)this.structureComposite);
    }

    @Override
    protected void readGraph(Resource resource) {
        if (this.graphListener != null) {
            this.graphListener.dispose();
        }
        this.graphListener = new StructureTabItem.GraphListener(this);
        Simantics.getSession().asyncRequest((Read)new DependencyGraphRequest(resource, this.levels, this.isInverted), (Listener)this.graphListener);
    }

    @Override
    protected String getJobLabel() {
        return "Loading dependencies graph";
    }
}

