/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets.arrays;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.browsing.ui.graph.impl.contributor.viewpoint.ViewpointContributorImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.properties.widgets.arrays.EnumerationNode;

public class AvailableEnumerations
extends ViewpointContributorImpl<ResourceArray> {
    public Collection<?> getContribution(ReadGraph graph, ResourceArray input) throws DatabaseException {
        Resource[] selection = input.resources;
        if (selection.length < 1) {
            return Collections.emptyList();
        }
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource configuration = null;
        Resource[] resourceArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            Resource conf = graph.getPossibleObject(r, l0.PartOf);
            if (configuration != null && !conf.equals(configuration)) {
                return Collections.emptyList();
            }
            configuration = conf;
            ++n2;
        }
        ArrayList<EnumerationNode> result = new ArrayList<EnumerationNode>();
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        if (configuration == null) {
            return result;
        }
        for (Resource r : (Collection)graph.syncRequest((Read)new ObjectsWithType(configuration, l0.ConsistsOf, sr.Enumeration))) {
            result.add(new EnumerationNode(r));
        }
        return result;
    }

    public String getViewpointId() {
        return "Available enumerations";
    }
}

