/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.browser.nodes;

import java.util.Collection;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.node.DeleteException;
import org.simantics.browsing.ui.common.node.IDeletableNode;
import org.simantics.browsing.ui.common.node.IModifiableNode;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.graph.impl.LabelModifier;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.browser.nodes.VariableNode;
import org.simantics.sysdyn.ui.utils.VariableNameValidator;
import org.simantics.utils.ui.ExceptionUtils;

public class EnumerationNode
extends VariableNode<Resource>
implements IModifiableNode,
IDeletableNode {
    public EnumerationNode(Resource resource) {
        super(resource);
    }

    public EnumerationNode(Variable variable, Resource represents) {
        super(variable, represents);
    }

    @Override
    public Labeler.Modifier getModifier(String columnId) {
        final Session session = Simantics.getSession();
        LabelModifier modifier = new LabelModifier(session, (Resource)this.data, ((Layer0)session.getService(Layer0.class)).HasName){

            public String isValid(String label) {
                if (!new VariableNameValidator().isValid((Resource)EnumerationNode.this.data, label)) {
                    return "Not valid";
                }
                return null;
            }

            public void modify(final String label) {
                try {
                    session.syncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            String originalName = (String)graph.getRelatedValue((Resource)(this).EnumerationNode.this.data, Layer0.getInstance((ReadGraph)graph).HasName);
                            if (!originalName.equals(label)) {
                                Resource configuration = graph.getPossibleObject((Resource)(this).EnumerationNode.this.data, Layer0.getInstance((ReadGraph)graph).PartOf);
                                new VariableNameValidator().renameInAllEquations(graph, configuration, originalName, label);
                                graph.claimLiteral((Resource)(this).EnumerationNode.this.data, Layer0.getInstance((ReadGraph)graph).HasName, (Object)label);
                            }
                        }
                    });
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
                super.modify(label);
            }
        };
        return modifier;
    }

    public void delete() throws DeleteException {
        try {
            Simantics.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException, CancelTransactionException {
                    graph.markUndoPoint();
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    for (Resource redeclaration : graph.getObjects((Resource)EnumerationNode.this.data, sr.Redeclaration_replacedEnumeration_Inverse)) {
                        graph.deny(redeclaration, sr.Module_redeclaration_Inverse);
                    }
                    for (Resource redeclaration : graph.getObjects((Resource)EnumerationNode.this.data, sr.Redeclaration_replacingEnumeration_Inverse)) {
                        graph.deny(redeclaration, sr.Module_redeclaration_Inverse);
                    }
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    Resource conf = graph.getPossibleObject((Resource)EnumerationNode.this.data, L0.PartOf);
                    for (Resource var : (Collection)graph.syncRequest((Read)new ObjectsWithType(conf, L0.ConsistsOf, sr.Variable))) {
                        Resource arrayIndexes = graph.getPossibleObject(var, sr.Variable_arrayIndexesList);
                        if (arrayIndexes == null || ListUtils.getNode((ReadGraph)graph, (Resource)arrayIndexes, (Resource)((Resource)EnumerationNode.this.data)) == null) continue;
                        ListUtils.removeElement((WriteGraph)graph, (Resource)arrayIndexes, (Resource)((Resource)EnumerationNode.this.data));
                    }
                    String enumerationName = (String)graph.getPossibleRelatedValue2((Resource)EnumerationNode.this.data, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING);
                    RemoverUtil.remove((WriteGraph)graph, (Resource)((Resource)EnumerationNode.this.data));
                    Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Removed Enumeration " + enumerationName + " " + ((Resource)EnumerationNode.this.data).toString()));
                }
            });
        }
        catch (DatabaseException e) {
            ExceptionUtils.logAndShowError((Throwable)e);
        }
    }
}

