/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.workbench.internal.contributions;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.gfx.HSVAdjustmentImageDescriptor;
import org.simantics.workbench.internal.Activator;

public class DumpHeapButtonTrim
extends Composite {
    private static final String PREF_HEAP_DUMP_PATH = "heap.dump.path";
    IPath path;
    LocalResourceManager resourceManager;
    boolean disabled = false;

    public DumpHeapButtonTrim(Composite parent) {
        super(parent, 0);
        this.restorePrefs();
        this.setLayout((Layout)new FillLayout());
        Button b = new Button((Composite)this, 8);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)b);
        b.setToolTipText("Dump Java heap for debugging");
        b.setImage(this.resourceManager.createImage(Activator.getImageDescriptor("img/lorry.png")));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DumpHeapButtonTrim.this.disabled) {
                    return;
                }
                DumpHeapButtonTrim.this.dumpHeap();
            }
        });
        if (DumpHeapButtonTrim.getBean() == null) {
            this.disabled = true;
            b.setImage(this.resourceManager.createImage(HSVAdjustmentImageDescriptor.adjustSaturation((ImageDescriptor)Activator.getImageDescriptor("img/lorry.png"), (float)0.0f)));
            b.setToolTipText("Sorry, Java heap dumping not available, JVM does not support HotSpotDiagnosticMXBean.");
        }
    }

    private void restorePrefs() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.simantics.workbench");
        String p = prefs.get(PREF_HEAP_DUMP_PATH, null);
        this.path = p == null ? null : new Path(p);
    }

    private void savePrefs() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.simantics.workbench");
        prefs.put(PREF_HEAP_DUMP_PATH, this.path.toPortableString());
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
    }

    private void dumpHeap() {
        String result;
        FileDialog fd = new FileDialog(this.getShell(), 8192);
        fd.setFilterExtensions(new String[]{"*.hprof"});
        if (this.path != null) {
            fd.setFileName(this.path.lastSegment());
            fd.setFilterPath(this.path.removeLastSegments(1).toOSString());
        }
        if ((result = fd.open()) == null) {
            return;
        }
        this.path = new Path(result);
        this.savePrefs();
        try {
            final File dumpFile = this.path.toFile();
            if (dumpFile.exists() && !dumpFile.delete()) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Delete Failed", (String)("Could not delete old heap dump file '" + dumpFile + "'.\n\nIs the file still in use?"));
                return;
            }
            new ProgressMonitorDialog(this.getShell()).run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Creating heap dump '" + dumpFile + "'", -1);
                    try {
                        Object bean = DumpHeapButtonTrim.getBean();
                        if (bean == null) {
                            return;
                        }
                        try {
                            Method m = bean.getClass().getMethod("dumpHeap", String.class, Boolean.TYPE);
                            m.invoke(bean, DumpHeapButtonTrim.this.path.toOSString(), true);
                        }
                        catch (IllegalArgumentException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (IllegalAccessException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (SecurityException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (NoSuchMethodException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            ExceptionUtils.logAndShowError((Throwable)t);
        }
        catch (InterruptedException e) {
            ExceptionUtils.logAndShowError((Throwable)e);
        }
    }

    private static Object getBean() {
        Class<?> beanClass = DumpHeapButtonTrim.getBeanClass();
        if (beanClass == null) {
            return null;
        }
        try {
            Object bean = ManagementFactory.newPlatformMXBeanProxy(ManagementFactory.getPlatformMBeanServer(), "com.sun.management:type=HotSpotDiagnostic", beanClass);
            return bean;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static Class<?> getBeanClass() {
        try {
            Class<?> clazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

