/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.workbench.search;

import java.util.Collection;
import java.util.Map;

import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.genericrelation.Dependencies;
import org.simantics.operation.Layer0X;
import org.simantics.scl.runtime.function.FunctionImpl5;

/**
 * dependenciesSearchFunction:
 *      (IProgressMonitor, ReadGraph, model : Resource, query : String, maxResults : Integer) -> QueryResult
 * 
 * @author Tuukka Lehtonen
 */
public class DependenciesSearchFunction extends FunctionImpl5<IProgressMonitor, ReadGraph, Resource, SearchQuery, Integer, SearchResult> {

    @Override
    public SearchResult apply(IProgressMonitor monitor, ReadGraph graph, Resource model, SearchQuery query, Integer maxResults) {
        try {
            Collection<Map<String, Object>> results = Searching.performSearch(graph,
                    Layer0X.getInstance(graph).Dependencies, model,
                    query.escapedWithForcedCase(false, false).getQuery(Dependencies.FIELD_NAME_SEARCH, Dependencies.FIELD_TYPES_SEARCH),
                    maxResults);

            return Searching.generateDependenciesSearchResult(graph, results);
        } catch (DatabaseException e) {
            Logger.defaultLogError(e);
        }
        return null;
    }

}
