package org.simantics.views.swt.client.impl;

import java.util.ArrayList;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.simantics.datatypes.literal.RGB;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.ui.colors.Colors;
import org.simantics.utils.ui.widgets.ITrackedColorProvider;
import org.simantics.utils.ui.widgets.TrackedModifyEvent;
import org.simantics.utils.ui.widgets.TrackedModifyListener;
import org.simantics.utils.ui.widgets.TrackedText;
import org.simantics.views.swt.client.base.SingleSWTViewNode;

public class SWTTrackedText extends SingleSWTViewNode<Text> {
	
	private static final RGB.Integer WHITE = new RGB.Integer(255, 255, 255);
	
	private static final long serialVersionUID = 7932335224632082902L;
	
	private TrackedText tt;
	
	protected Color invalidBackgroundColor;
	protected Color inactiveBackgroundColor;
	protected Color hoverBackgroundColor;
	protected Color editingBackgroundColor;

	public Function1<String, String> modifier;
	public Function1<String, String> validator;
	
	public RGB.Integer invalidBackground = WHITE;
	public RGB.Integer inactiveBackground = WHITE;
	public RGB.Integer hoverBackground = WHITE;
	public RGB.Integer editingBackground = WHITE;

	protected ArrayList<TrackedModifyListener> listeners = new ArrayList<TrackedModifyListener>();
	
	public void addModifyListener(TrackedModifyListener listener) {
		this.listeners.add(listener);
	}
	
	@Override
	public void createControls(Composite parent) {
		
		tt = new TrackedText(parent, style);
		control = tt.getWidget();

		setProperties();
		
		tt.setColorProvider(new ITrackedColorProvider() {
			
			@Override
			public Color getInvalidBackground() {
				return invalidBackgroundColor;
			}
			
			@Override
			public Color getInactiveBackground() {
				return inactiveBackgroundColor;
			}
			
			@Override
			public Color getHoverBackground() {
				return hoverBackgroundColor;
			}
			
			@Override
			public Color getEditingBackground() {
				return editingBackgroundColor;
			}
			
		});
		
		tt.setInputValidator(new IInputValidator() {
			
			@Override
			public String isValid(String newText) {
				if(validator != null) return validator.apply(newText);
				else return null;
			}
			
		});
		
		tt.addModifyListener(new TrackedModifyListener() {
			
			@Override
			public void modifyText(TrackedModifyEvent e) {
				if(modifier != null)
					modifier.apply(e.getText());
				for(TrackedModifyListener listener : listeners) listener.modifyText(e);
			}
			
		});
		
	}

	@Override
	public void synchronizeText(String text) {
		if(text != null) control.setText(text);
	}
	
	final public void synchronizeInvalidBackground(RGB.Integer invalidBackground) {
		if(invalidBackground != null) invalidBackgroundColor = Colors.swt(control.getDisplay(), invalidBackground);
	}

	final public void synchronizeInactiveBackground(RGB.Integer inactiveBackground) {
		if(inactiveBackground != null) inactiveBackgroundColor = Colors.swt(control.getDisplay(), inactiveBackground);
	}

	final public void synchronizeHoverBackground(RGB.Integer hoverBackground) {
		if(hoverBackground != null) hoverBackgroundColor = Colors.swt(control.getDisplay(), hoverBackground);
	}

	final public void synchronizeEditingBackground(RGB.Integer editingBackground) {
		if(editingBackground != null) editingBackgroundColor = Colors.swt(control.getDisplay(), editingBackground);
	}
	
	final public void synchronizeValidator(Function1<String, String> validator) {
		
	}

	final public void synchronizeModifier(Function1<String, String> modifier) {
		
	}
	
}
