package org.simantics.views.swt.client.impl;

import java.util.List;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.simantics.scl.runtime.tuple.Tuple;


public class SWTCCombo extends SWTComboBase<CCombo> {
	
	private static final long serialVersionUID = 2529612234578912642L;

	private final SelectionListener listener = new SelectionListener() {

		@Override
		public void widgetSelected(SelectionEvent e) {
			
			int selectionIndex = control.getSelectionIndex();
			if (selectionIndex == -1)
			    return;

			String[] items = control.getItems();
			
			String key = items[selectionIndex];
			
			if(modifier != null)
				modifier.apply(key);
			
			selected = key;
			
		}

		@Override
		public void widgetDefaultSelected(SelectionEvent e) {
			
			widgetSelected(e);
			
		}
		
	};

	@Override
	public void createControls(Composite parent) {
		
		control = new CCombo(parent, style);
		control.addSelectionListener(listener);
		
		setProperties();
		
	}
	
	public void synchronizeAvailable(List<Tuple> available) {
		if(available != null) {
			
	        control.removeSelectionListener(listener);
	        control.setData(available);
	        control.clearSelection();
	        try {
	        	control.removeAll();
	        } catch (Throwable t) {
	            t.printStackTrace();
	        }
	        if (available != null) {
	            int index = 0;
	            for(Tuple key : available) {
	            	control.add((String)key.toArray()[0]);
	            	control.setData((String)key.toArray()[0], index++);
	            }
	            String selectionKey = (String)control.getData("_SelectionKey");
	            if(selectionKey != null) {
	                Integer selectionIndex = (Integer)control.getData(selectionKey);
	                if(selectionIndex != null) control.select(selectionIndex);
	            }
	        }
	        control.addSelectionListener(listener);
			
//			// This seems to be necessary for correct size computations
//			widget.getControl().getParent().layout(true);
		}
	}

	public void synchronizeSelected(String selected) {
		if(selected != null) {
			
            control.removeSelectionListener(listener);
	        control.setData("_SelectionKey", selected);
	        Integer selectionIndex = (Integer)control.getData(selected);
	        if(selectionIndex != null) control.select(selectionIndex);
            control.addSelectionListener(listener);
            		
//			// This seems to be necessary for correct size computations
//			widget.getControl().getParent().layout(true);
		}
	}
	
	public String readSelected() {
		return selected;
	}
	
	public List<Tuple> readAvailable() {
		return available;
	}
	
}
