package org.simantics.views.swt.client.impl;

import java.io.ByteArrayInputStream;
import java.util.Arrays;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.views.swt.client.base.SingleSWTViewNode;

public class SWTButton extends SingleSWTViewNode<Button> {
	
	private static final long serialVersionUID = 7932335224632082902L;

	public Function1<Object, Object> modifier;
	public byte[] image;
	public String tooltip;

	private transient ImageDescriptor imageDesc;

	@Override
	public void createControls(Composite parent) {
		
		control = new Button(parent, style);

		setProperties();

		control.addSelectionListener(new SelectionListener() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				if(modifier != null)
					modifier.apply(SWTButton.this);
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				widgetSelected(e);
			}
			
		});
		
	}
	
	@Override
	public void synchronizeText(String text) {
		if(text != null) {
			control.setText(text);
			// This seems to be necessary for correct size computations
			control.getParent().layout(true);
		}
	}

	public void synchronizeImage(byte[] image) {
		ResourceManager rm =  getResourceManager();
		ImageDescriptor oldDesc = imageDesc;
		if (image != null)
			control.setImage(rm.createImage(imageDesc = new Descriptor(image)));
		if (oldDesc != null)
			rm.destroyImage(oldDesc);
	}
	
	public void synchronizeModifier(Function1<Object, Object> modifier) {
		
	}
	
	public void synchronizeTooltip(String tooltip) {
		if(tooltip != null) control.setToolTipText(tooltip);
	}

	static class Descriptor extends ImageDescriptor {
	    
	    final byte[] data;
	    final int hash;
	    
	    public Descriptor(byte[] data) {
	        this.data = data;
	        this.hash = Arrays.hashCode(data);
	    }

	    @Override
	    public ImageData getImageData() {
	        return new ImageLoader().load(new ByteArrayInputStream(data))[0];
	    }

	    @Override
	    public int hashCode() {
	        return hash;
	    }

	    @Override
	    public boolean equals(Object obj) {
	        if (this == obj)
	            return true;
	        if (obj == null)
	            return false;
	        if (getClass() != obj.getClass())
	            return false;
	        Descriptor other = (Descriptor) obj;
	        if (!Arrays.equals(data, other.data))
	            return false;
	        return true;
	    }

	}

}
