package org.simantics.views.swt.client.impl;

import java.util.Collection;
import java.util.Iterator;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.simantics.views.swt.client.base.ISWTViewNode;
import org.simantics.views.swt.client.base.SWTParentNode;
import org.simantics.views.swt.client.base.SingleSWTViewNode;

public class SWTAlternative extends SingleSWTViewNode<Composite> {
	
	private static final long serialVersionUID = -3427445018396850285L;

	private org.eclipse.swt.widgets.Composite parent;
	
	public Boolean condition = false;
	
	@Override
	public void createControls(org.eclipse.swt.widgets.Composite parent) {
		
		this.parent = parent;
		
    	control = new Composite(parent, style);
    	
    	GridLayoutFactory.fillDefaults().applyTo(control);
    	GridDataFactory.fillDefaults().grab(true, true).applyTo(control);
    	
    	Collection<ISWTViewNode> nodes = children.values();
    	if(nodes.size() > 0) {
    		Iterator<ISWTViewNode> it = nodes.iterator();
	    	if(condition == null || !condition) {
	    		if(nodes.size() > 1) {
		    		it.next();
		    		it.next().createControls(control);
	    		}
	    	} else {
	    		it.next().createControls(control);
	    	}
    	}
    	
    	// TODO: can not use generic setProperties since if forms a loop through synchronizeCondition
		synchronizeForeground(foreground);
		synchronizeBackground(background);
		synchronizeFont(font);
		synchronizeLayoutData(layoutData);
    	
	}
	
	final private void reset(ISWTViewNode node) {

		node.reset();
		if(node instanceof SWTParentNode) {
			SWTParentNode parentNode = (SWTParentNode)node;
			for(ISWTViewNode child : parentNode.getChildComposites()) reset(child);
		}
		
	}
	
	final public void synchronizeCondition(Boolean condition) {
		
		if(condition == null) return;
		
		Composite currentControl = control;
		
		reset(this);
		
		currentControl.dispose();
		
		createControls(parent);
		
		parent.layout(true);
		
	}
	
}
