package org.simantics.views.swt.client.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ParentNode;

abstract public class SWTParentNode extends ParentNode<ISWTViewNode> implements ISWTViewNode {

	private boolean disposed = false;
	
	private static final long serialVersionUID = -3548136282051185971L;

	class M implements Map<String, ISWTViewNode> {
		
		ArrayList<ISWTViewNode> list = new ArrayList<ISWTViewNode>();
		Hashtable<String, ISWTViewNode> table = new Hashtable<String, ISWTViewNode>();
		
		@Override
		public void clear() {
			table.clear();
			list.clear();
		}
		@Override
		public boolean containsKey(Object arg0) {
			return table.containsKey(arg0);
		}
		@Override
		public boolean containsValue(Object arg0) {
			return table.containsValue(arg0);
		}
		@Override
		public Set<java.util.Map.Entry<String, ISWTViewNode>> entrySet() {
			return table.entrySet();
		}
		@Override
		public ISWTViewNode get(Object arg0) {
			return table.get(arg0);
		}
		@Override
		public boolean isEmpty() {
			return table.isEmpty();
		}
		@Override
		public Set<String> keySet() {
			return table.keySet();
		}
		@Override
		public ISWTViewNode put(String arg0, ISWTViewNode arg1) {
			ISWTViewNode exist = table.put(arg0, arg1);
			if(exist != null) list.remove(exist);
			list.add(arg1);
			return exist;
		}
		@Override
		public void putAll(Map<? extends String, ? extends ISWTViewNode> arg0) {
			for(Map.Entry<? extends String, ? extends ISWTViewNode> entry : arg0.entrySet())
				put(entry.getKey(), entry.getValue());
		}
		@Override
		public ISWTViewNode remove(Object arg0) {
			ISWTViewNode node = table.remove(arg0);
			if(node != null) list.remove(node);
			return node;
		}
		@Override
		public int size() {
			return table.size();
		}
		@Override
		public Collection<ISWTViewNode> values() {
			return list;
		}
		
	}
	
	@Override
	public SWTRoot getRootNode() {
		ParentNode<?> root = super.getRootNode();
		return (root instanceof SWTRoot) ? (SWTRoot) root : null;
	}
	
	public ResourceManager getResourceManager() {
		SWTRoot root = getRootNode();
		if (root == null)
			throw new IllegalStateException(this + " not attached to SWTRoot root node");
		return root.getResourceManager();
	}
	
	public ResourceManager peekResourceManager() {
		SWTRoot root = getRootNode();
		return root != null ? root.peekResourceManager() : null;
	}

	@Override
	final public void asyncRemoveNode(INode node) {
		throw new Error();
	}
	
	@Override
	protected Map<String, ISWTViewNode> createChildMap() {
		return new M();
	}
	
	protected void createChildComposites() {
		createChildComposites((Composite)getControl());
	}

	protected void createChildComposites(Composite composite) {
		for(ISWTViewNode node : children.values()) node.createControls(composite);
	}
	
	@Override
	public Control getControl() {
		return null;
	}
	
	@Override
	public IWorkbenchSite getSite() {
		
		ParentNode<?> parentNode = getParent();
		ISWTViewNode swtParent = (ISWTViewNode)parentNode;
		return swtParent.getSite();
		
	}

	public Collection<ISWTViewNode> getChildComposites() {
		return children.values();
	}
	
	@Override
	public boolean isNodeDisposed() {
		return disposed;
	}
	
	public void dispose() {
		assert(!isNodeDisposed());
		for(ISWTViewNode child : getChildComposites())
			child.dispose();
		cleanup();
		disposed = true;
	}
	
}
