/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.format;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Locale;
import org.simantics.utils.format.SwitchFormat;

public enum ValueFormat {
    Currency(new DecimalFormat("#,##0.#######;-#,##0.#####", Impl.access$0())),
    Scientific(new DecimalFormat("0.###E0", Impl.access$0())),
    Engineering(new DecimalFormat("##0.###E0", Impl.access$0())),
    Default(new SwitchFormat(1.0E-5, 100000.0, ValueFormat.Scientific.format, ValueFormat.Currency.format, ValueFormat.Scientific.format));

    public final NumberFormat format;
    private static DecimalFormat[] decimalFormats;
    private static Format[] defaultFormats;

    static {
        decimalFormats = new DecimalFormat[17];
        defaultFormats = new Format[17];
        String decimals = "";
        int i = 0;
        while (i < decimalFormats.length) {
            ValueFormat.decimalFormats[i] = new DecimalFormat("#,###" + decimals + ";-#,###" + decimals, Impl.SYMBOLS);
            ValueFormat.defaultFormats[i] = new SwitchFormat(1.0E-5, 100000.0, ValueFormat.Scientific.format, decimalFormats[i], ValueFormat.Scientific.format);
            if (i == 0) {
                decimals = String.valueOf(decimals) + ".";
            }
            decimals = String.valueOf(decimals) + "#";
            ++i;
        }
    }

    private ValueFormat(NumberFormat format) {
        this.format = format;
    }

    public Format toFormat(int noOfDecimals) {
        switch (this) {
            case Currency: {
                return noOfDecimals > decimalFormats.length || noOfDecimals < 0 ? decimalFormats[decimalFormats.length - 1] : decimalFormats[Math.min(noOfDecimals, 16)];
            }
            case Scientific: {
                return this.format;
            }
            case Engineering: {
                return this.format;
            }
            case Default: {
                return noOfDecimals > defaultFormats.length || noOfDecimals < 0 ? defaultFormats[defaultFormats.length - 1] : defaultFormats[Math.min(noOfDecimals, 16)];
            }
        }
        return this.format;
    }

    public static void main(String[] args) {
        double value = 1234567.8901234567;
        int i = 0;
        while (i < 10) {
            System.out.println("value=" + value + ", decimalformat[" + i + "]=" + decimalFormats[i].format(value));
            ++i;
        }
        value = 567.890123456789;
        i = 0;
        while (i < 10) {
            System.out.println("value=" + value + ", decimalformat[" + i + "]=" + decimalFormats[i].format(value));
            ++i;
        }
    }

    private static class Impl {
        private static final DecimalFormatSymbols SYMBOLS = DecimalFormatSymbols.getInstance(Locale.US);

        static {
            SYMBOLS.setGroupingSeparator(' ');
        }

        private Impl() {
        }
    }
}

