/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.internal.awt;

import java.awt.AWTEvent;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.simantics.utils.ui.internal.awt.SwtInputBlocker;

class AwtDialogListener
implements AWTEventListener,
ComponentListener {
    private final List modalDialogs = new ArrayList();
    private final Display display;

    AwtDialogListener(Display display) {
        assert (display != null);
        this.display = display;
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 64L);
    }

    private void handleRemovedDialog(Dialog awtDialog, boolean removeListener) {
        assert (awtDialog != null);
        assert (this.modalDialogs != null);
        assert (this.display != null);
        assert (EventQueue.isDispatchThread());
        if (removeListener) {
            awtDialog.removeComponentListener(this);
        }
        if (this.modalDialogs.remove(awtDialog)) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    SwtInputBlocker.unblock();
                }
            });
        }
    }

    private void handleAddedDialog(Dialog awtDialog) {
        assert (awtDialog != null);
        assert (this.modalDialogs != null);
        assert (EventQueue.isDispatchThread());
        if (this.modalDialogs.contains(awtDialog) || !awtDialog.isModal() || !awtDialog.isVisible()) {
            return;
        }
        this.modalDialogs.add(awtDialog);
        awtDialog.addComponentListener(this);
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                SwtInputBlocker.block();
            }
        });
    }

    void requestFocus() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!$assertionsDisabled && AwtDialogListener.this.modalDialogs == null) {
                    throw new AssertionError();
                }
                int size = AwtDialogListener.this.modalDialogs.size();
                if (size > 0) {
                    Dialog awtDialog = (Dialog)AwtDialogListener.this.modalDialogs.get(size - 1);
                    awtDialog.requestFocus();
                    awtDialog.toFront();
                }
            }
        });
    }

    private void handleOpenedWindow(WindowEvent event) {
        assert (event != null);
        assert (EventQueue.isDispatchThread());
        Window window = event.getWindow();
        if (window instanceof Dialog) {
            this.handleAddedDialog((Dialog)window);
        }
    }

    private void handleClosedWindow(WindowEvent event) {
        assert (event != null);
        assert (EventQueue.isDispatchThread());
        Window window = event.getWindow();
        if (window instanceof Dialog) {
            this.handleRemovedDialog((Dialog)window, true);
        }
    }

    private void handleClosingWindow(WindowEvent event) {
        assert (event != null);
        assert (EventQueue.isDispatchThread());
        Window window = event.getWindow();
        if (window instanceof Dialog) {
            final Dialog dialog = (Dialog)window;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AwtDialogListener.this.handleRemovedDialog(dialog, true);
                }
            });
        }
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        assert (event != null);
        assert (EventQueue.isDispatchThread());
        switch (event.getID()) {
            case 200: {
                this.handleOpenedWindow((WindowEvent)event);
                break;
            }
            case 202: {
                this.handleClosedWindow((WindowEvent)event);
                break;
            }
            case 201: {
                this.handleClosingWindow((WindowEvent)event);
                break;
            }
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        assert (e != null);
        assert (EventQueue.isDispatchThread());
        Object obj = e.getSource();
        if (obj instanceof Dialog) {
            this.handleRemovedDialog((Dialog)obj, false);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
        assert (e != null);
        assert (EventQueue.isDispatchThread());
        Object obj = e.getSource();
        if (obj instanceof Dialog) {
            this.handleAddedDialog((Dialog)obj);
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }
}

