/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 * Created on 6.10.2005
 * @author Toni Kalajainen 
 */
package org.simantics.utils.ui.validators;

import org.eclipse.jface.dialogs.IInputValidator;

/**
 * Validator Multiplexer. Allows to combine multiple validators
 * 
 */
public class MultiValidator implements IInputValidator {

    private final IInputValidator validators[];

    private final AcceptType acceptType;

    public enum AcceptType {
        ALL_MUST_PASS, ONE_MUST_PASS
    };

    public MultiValidator(IInputValidator validators[], AcceptType acceptType) {
        this.acceptType = acceptType;
        this.validators = new IInputValidator[validators.length];
        for (int i = 0; i < validators.length; i++)
            this.validators[i] = validators[i];
    }

    public String isValid(String newText) {
        if (acceptType == AcceptType.ALL_MUST_PASS) {
            for (int i = 0; i < validators.length; i++) {
                String result = validators[i].isValid(newText);
                if (result != null)
                    return result;
            }
            return null;
        }
        
        if (acceptType == AcceptType.ONE_MUST_PASS) {
            String error = null;
            for (int i = 0; i < validators.length; i++) {
                String result = validators[i].isValid(newText);                
                if (result != null)
                    error = result;
                else
                    return null;
            }
            return error;
        }
        return null;
    }

}
