/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 *
 * @author Toni Kalajainen
 */
package org.simantics.utils.ui.jface;

import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;

public class FontCellEditor extends DialogCellEditor {

    private Label fontLabel;
        
    public FontCellEditor() {
        super();
    }

    public FontCellEditor(Composite parent, int style) {
        super(parent, style);
    }



    public FontCellEditor(Composite parent) {
        super(parent);
    }

    @Override
    protected Control createContents(Composite cell) {
        fontLabel = new Label(cell, SWT.LEFT);
        Color bg = cell.getBackground();
        fontLabel.setBackground(bg);
        return fontLabel;
    }
    

    @Override
    protected Object openDialogBox(Control cellEditorWindow) {
        
        FontDialog fontDialog = new FontDialog(cellEditorWindow.getShell());
        FontData fontData = (FontData) getValue();
        if (fontData!=null)
            fontDialog.setFontList(new FontData[] {fontData});
        return fontDialog.open();
    }

    @Override
    protected void updateContents(Object value) {
        FontData fontData = (FontData) value;
        if (fontData==null) {
            fontLabel.setText("select font...");
            return;
        }
        
        StringBuilder sb = new StringBuilder();
        sb.append( fontData.getName() );
        sb.append( ", "+fontData.getHeight() );
        if ( (fontData.getStyle() & SWT.BOLD)>0 )
            sb.append(", Bold");
        if ( (fontData.getStyle() & SWT.ITALIC)>0 )
            sb.append(", Italic");
        fontLabel.setText(sb.toString());
    }
    
    
}
