/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 *
 * @author Toni Kalajainen
 */
package org.simantics.utils.ui.color;

import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ColorGradientCellEditor extends DialogCellEditor {

    public ColorGradientCellEditor(Composite parent) {
        super(parent);
    }

    /**
     * The composite showing the gradient
     */
    private ColorGradientCanvas canvas;

    /* (non-Javadoc)
     * Method declared on DialogCellEditor.
     */
    protected Control createContents(Composite cell) {
        Color bg = cell.getBackground();
        canvas = new ColorGradientCanvas(cell, getStyle());
        canvas.setBackground(bg);
        return canvas;
    }

    /* (non-Javadoc)
     * Method declared on DialogCellEditor.
     */
    protected Object openDialogBox(Control cellEditorWindow) {
        ColorGradient value = (ColorGradient)getValue();
        ColorGradientDialog dialog = new ColorGradientDialog(cellEditorWindow.getShell(), value);
        if (dialog.open() == Window.OK)
            return dialog.getGradient();
        return value;
    }

    /* (non-Javadoc)
     * Method declared on DialogCellEditor.
     */
    protected void updateContents(Object value) {
        ColorGradient cg = (ColorGradient) value;
        canvas.setGradient(cg);
    }    
    

}
