package org.simantics.utils;

import java.io.File;

public interface TempFiles {

    /**
     * @return the directory containing all temporary file names generated by
     *         this instance.
     */
    public File getRoot();

    /**
     * @param directory
     *            possible directory under {@link #getRoot()}
     * @param suffix
     *            suffix of generated temporary file name without the '.'
     *            character separating the random start and the extension
     *            (suffix)
     * @return temporary file with a random name that ends in
     *         <code>suffix</code> and is contained by a directory under
     *         {@link #getRoot()} with the name <code>directory</code>
     */
    public File getTempfile(String directory, String suffix);

    /**
     * Create a new TempFiles instance that will produce temporary file names in
     * a specified subdirectory of this TempFiles location.
     * 
     * @param directory
     * @return the sub-TempFiles instance
     * @since 1.16
     */
    public TempFiles subdirectory(String directory);

}
