/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.datastructures;

import java.util.Collection;
import java.util.ConcurrentModificationException;

public class SelectionUtils {

    public static <T> T getSingle(Collection<T> collection) {
        if(collection.size() != 1)
            throw new RuntimeException("Size of the collection is not one.");
        for(T obj : collection)
            return obj;
        throw new ConcurrentModificationException("collection was emptied before iteration");
    }
    
    public static <T> T getAtMostOne(Collection<T> collection) {
        if(collection.size() > 1)
            throw new RuntimeException("Size of the collection is greater than one.");
        for(T obj : collection)
            return obj;
        return null;
    }

}
