/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench.dialogs;

import java.util.Comparator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;
import org.simantics.db.Resource;
import org.simantics.db.exception.InvalidResourceReferenceException;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.Pair;

public abstract class ResourceSelectionDialog2<T>
extends FilteredItemsSelectionDialog {
    Map<T, Pair<String, Image>> nameMap;
    String title;

    public ResourceSelectionDialog2(Shell shell, Map<T, Pair<String, Image>> parameter, String title) {
        this(shell, parameter, title, true);
    }

    public ResourceSelectionDialog2(Shell shell, Map<T, Pair<String, Image>> parameter, String title, boolean multi) {
        super(shell, multi);
        this.nameMap = parameter;
        this.title = title;
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                Pair<String, Image> pair = ResourceSelectionDialog2.this.nameMap.get(element);
                if (pair != null) {
                    return (String)pair.first;
                }
                return null;
            }

            public Image getImage(Object element) {
                Pair<String, Image> pair = ResourceSelectionDialog2.this.nameMap.get(element);
                if (pair != null) {
                    return (Image)pair.second;
                }
                return null;
            }
        };
        this.setListLabelProvider((ILabelProvider)labelProvider);
        this.setDetailsLabelProvider((ILabelProvider)labelProvider);
        this.setSelectionHistory(new ResourceSelectionHistory());
        this.setTitle(title);
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ResourceSelectionDialogItemsFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        for (T o : this.nameMap.keySet()) {
            contentProvider.add(o, itemsFilter);
        }
        if (progressMonitor != null) {
            progressMonitor.done();
        }
    }

    protected abstract IDialogSettings getBaseDialogSettings();

    protected IDialogSettings getDialogSettings() {
        IDialogSettings base = this.getBaseDialogSettings();
        IDialogSettings settings = base.getSection(this.title);
        if (settings == null) {
            settings = base.addNewSection(this.title);
        }
        return settings;
    }

    public String getElementName(Object item) {
        return (String)this.nameMap.get((Object)item).first;
    }

    protected Comparator<?> getItemsComparator() {
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return ((String)ResourceSelectionDialog2.this.nameMap.get((Object)o1).first).compareToIgnoreCase((String)ResourceSelectionDialog2.this.nameMap.get((Object)o2).first);
            }
        };
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    public void updateStatus(IStatus status) {
        super.updateStatus(status);
    }

    class ResourceSelectionDialogItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public ResourceSelectionDialogItemsFilter() {
            super((FilteredItemsSelectionDialog)ResourceSelectionDialog2.this);
            String patternText = this.getPattern();
            this.patternMatcher = new SearchPattern();
            if (patternText != null && patternText.length() > 0) {
                this.patternMatcher.setPattern(patternText);
            } else {
                this.patternMatcher.setPattern("*");
            }
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean matchItem(Object item) {
            return this.matches((String)ResourceSelectionDialog2.this.nameMap.get((Object)item).first);
        }
    }

    class ResourceSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        ResourceSelectionHistory() {
        }

        protected Object restoreItemFromMemento(IMemento memento) {
            return null;
        }

        protected void storeItemToMemento(Object item, IMemento memento) {
            if (item instanceof Resource) {
                try {
                    SerialisationSupport support = (SerialisationSupport)SimanticsUI.getSession().getService(SerialisationSupport.class);
                    memento.putTextData(support.getResourceSerializer().createRandomAccessId((Resource)item));
                }
                catch (InvalidResourceReferenceException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

