/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;

/**
 * @author Tuukka Lehtonen
 */
public class TitleRequest implements Read<String> {

    private final String               editorId;

    private final IResourceEditorInput input;

    public TitleRequest(String editorId, IResourceEditorInput input) {
        this.editorId = editorId;
        this.input = input;
    }

    @Override
    public String perform(ReadGraph graph) throws DatabaseException {
        Resource r = input.getResource();

        try {
            String n = null;
            IEditorNamingService ems = EditorNaming.getNamingService(graph, r);
            if (ems != null)
                n = ems.getName(graph, editorId, input);
            if (n == null) {
                if (r == null)
                    return "no input resource";
                n = graph.adapt(r, String.class);
            }

            return n;
        } catch (AdaptionException e) {
            return NameUtils.getSafeName(graph, r);
        }
    }

}