/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench;

import java.util.List;

import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener4;
import org.eclipse.ui.IWindowListener;

import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.progress.ProgressRegion;

/**
 * Handler for perspectiveBars ExtensionPoint
 * 
 * FIXME : statusLine widgets are not restored into original positions.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
@SuppressWarnings("restriction")
public class PerspectiveBarsActivator implements IPerspectiveListener4, IWindowListener {

    private IWorkbenchWindow                    activeWindow;


    public PerspectiveBarsActivator() {
        PlatformUI.getWorkbench().addWindowListener(this);
    }

    public void dispose() {
        PlatformUI.getWorkbench().removeWindowListener(this);
    }

    //------------------------------------------------------------------------
    // IPerspectiveListener4
    //------------------------------------------------------------------------

    @Override
    public void perspectivePreDeactivate(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    @Override
    public void perspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    @Override
    public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    @Override
    public void perspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    @Override
    public void perspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective,
            IPerspectiveDescriptor newPerspective) {
    }

    @Override
    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective,
            IWorkbenchPartReference partRef, String changeId) {
        // See IWorkbenchPage.CHANGED_* constants for change id's.
    }

    @Override
    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        activatePerspective(perspective.getId());
    }

    @Override
    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        // See IWorkbenchPage.CHANGED_* constants for change id's.
    }

    //------------------------------------------------------------------------
    // IWindowListener
    //------------------------------------------------------------------------

    @Override
    public void windowActivated(IWorkbenchWindow window) {
//        System.out.println("attaching to window: " + window);
        attachToWindow(window);
    }

    @Override
    public void windowClosed(IWorkbenchWindow window) {
    }

    @Override
    public void windowDeactivated(IWorkbenchWindow window) {
//        System.out.println("detaching from window: " + window);
        detachFromWindow(window);
    }

    @Override
    public void windowOpened(IWorkbenchWindow window) {
    }

    //------------------------------------------------------------------------
    // UTILITIES
    //------------------------------------------------------------------------

    private void attachToWindow(IWorkbenchWindow window) {
        activeWindow = window;
        window.addPerspectiveListener(this);
        IPerspectiveDescriptor perspective = window.getActivePage().getPerspective();
        if (perspective != null) {
            activatePerspective(perspective.getId());
        }
    }

    private void detachFromWindow(IWorkbenchWindow window) {
        window.removePerspectiveListener(this);
    }




    private Menu menu;
    
	private void activatePerspective(String perspectiveId) {
//        System.out.println("activating perspective: " + perspectiveId);
    	
        
        List<IPerspectiveBarsExtension> exts = PerspectiveBarsManager.getInstance().getExtensions(perspectiveId);
        Boolean menuBar = null;
        Boolean coolBar = null;
        Boolean statusLine = null;
        Boolean perspectiveBar = null;
        Boolean fastViewBar = null;
        Boolean progressIndicator = null;
        for (IPerspectiveBarsExtension ext : exts) {
            if (menuBar == null)
            	menuBar = ext.getMenuBar();
            if (coolBar == null)
            	coolBar = ext.getCoolBar();
            if (statusLine == null)
            	statusLine = ext.getStatusLine();
            if (perspectiveBar == null)
            	perspectiveBar = ext.getPerspectiveBar();
            if (fastViewBar == null)
            	fastViewBar = ext.getFastViewBar();
            if (progressIndicator == null)
            	progressIndicator = ext.getProgressIndicator();
        }
        
        if (activeWindow instanceof WorkbenchWindow) {
        	WorkbenchWindow window = (WorkbenchWindow)activeWindow;
        	
        	if (menuBar == null || menuBar == true) {
        		Menu m = window.getShell().getMenuBar();
        		if (m == null && menu != null) {
        			window.getShell().setMenuBar(menu);
        		}
        	} else {
        		Menu m = window.getShell().getMenuBar();
        		if (m != null) {
        			menu = m;
        			window.getShell().setMenuBar(null);
        			
        		}
        	}
        	
        	if (coolBar == null || coolBar == true) {
        		window.setCoolBarVisible(true);
        	} else {
        		window.setCoolBarVisible(false);
        	}
        	
        	if (statusLine == null || statusLine == true) {
        		window.setStatusLineVisible(true);
        		//window.showHeapStatus(true);
        	} else {
        		window.setStatusLineVisible(false);
        		//window.showHeapStatus(false);
        	}
        	
        	if (perspectiveBar == null || perspectiveBar == true) {
        		window.setPerspectiveBarVisible(true);
        	} else {
        		window.setPerspectiveBarVisible(false);
        	}

        	// Bug 479522 - Remove unused fastView methods in WorkbenchWindow 
        	//if (fastViewBar == null || fastViewBar == true) {
        	//	window.setFastViewBarVisible(true);
        	//} else {
        	//	window.setFastViewBarVisible(false);
        	//}
        	
        	if (progressIndicator == null || progressIndicator == true) {
        		ProgressRegion r = window.getProgressRegion();
        		if (r != null)
        			r.getControl().setVisible(true);
        		
        	} else {
        		ProgressRegion r = window.getProgressRegion();
        		if (r != null)
        			r.getControl().setVisible(false);
        	}
        	// Bug 486768 - Delete unused internal ITrimManager
        	//window.getTrimManager().forceLayout();
        }
      
    }

}
