/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.internal;

import java.util.concurrent.TimeUnit;

import org.simantics.db.management.ISessionContext;
import org.simantics.internal.TimedSessionCache;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.cache.SoftTimedCache;

/**
 * @author Tuukka Lehtonen
 * @since 2007-08-28
 * @deprecated do not use, no direct replacement
 */
@Deprecated
public final class SessionUtils {

    /**
     * Puts the specified session on the list of to-be-closed sessions. If no
     * one needs the session after 10 seconds, it will be closed automatically.
     * It will also be closed automatically if there is memory pressure to do
     * so.
     * 
     * @param ctx
     * @see TimedSessionCache
     */
    public static void releaseUnusedSessionAfterHoldTime(ISessionContext ctx) {
        releaseUnusedSessionAfterHoldTime(ctx, 10000);
    }

    /**
     * Puts the specified session on the list of to-be-closed sessions. If no
     * one needs the session after the specified amount of time, it will be
     * closed automatically. It will also be closed automatically if there is
     * memory pressure to do so.
     * 
     * @param ctx
     * @param holdTimeMs hold time for released session in milliseconds
     * @see TimedSessionCache
     */
    public static void releaseUnusedSessionAfterHoldTime(ISessionContext ctx, long holdTime) {
        if (ctx == null)
            throw new IllegalArgumentException("null session context");

        // See if the session is used by the UI.
        // If it is, don't put the session on the release queue.
        if (SimanticsUI.isInUse(ctx))
            return;

        synchronized (SessionUtils.class) {
            // Ensure that all previously cached sessions are scheduled for disposal.
            TimedSessionCache cache = TimedSessionCache.getCache();
            for (SoftTimedCache<Object, ISessionContext>.CacheEntry e : cache.getEntries()) {
                e.schedule(holdTime, TimeUnit.MILLISECONDS);
            }

            // Cache this session for an infinite amount of time.
            TimedSessionCache.getCache().put(ctx.getSession(), ctx, 5, TimeUnit.MINUTES);
        }
    }

//    private static ISessionContext releaseFromCache(Object address) {
//        synchronized (SessionUtils.class) {
//            ISessionContext cachedCtx = TimedSessionCache.getCache().release(address);
//            return cachedCtx;
//        }
//    }
//
//    /**
//     * @param monitor
//     * @param server
//     * @return
//     * @throws Layer0MissingException
//     * @throws IOException
//     */
//    static ISessionContext getSessionContext(IProgressMonitor monitor, ServerInfo server, UserAuthenticator auth)
//    throws DatabaseException, IOException
//    {
//        return getSessionContext(monitor, server, auth, true);
//    }
//
//    /**
//     * @param monitor
//     * @param server
//     * @return
//     * @throws Layer0MissingException
//     * @throws IOException
//     */
//    static ISessionContext getSessionContext(IProgressMonitor monitor, ServerInfo server)
//    throws DatabaseException, IOException
//    {
//        return getSessionContext(monitor, server, null, true);
//    }
//
//    /**
//     * @param monitor
//     * @param server
//     * @param registerServices
//     * @return
//     * @throws Layer0MissingException
//     * @throws IOException
//     */
//    static ISessionContext getSessionContext(IProgressMonitor monitor, ServerInfo server, UserAuthenticator auth, boolean registerServices)
//    throws DatabaseException, IOException
//    {
//        return getSessionContext(monitor, server.getName(), auth, registerServices);
//    }
//
//    /**
//     * @param monitor
//     * @param server
//     * @param registerServices
//     * @return
//     * @throws Layer0MissingException
//     * @throws IOException
//     */
//    static ISessionContext getSessionContext(IProgressMonitor monitor, ServerInfo server, boolean registerServices)
//    throws DatabaseException, IOException
//    {
//        return getSessionContext(monitor, server.getAddress(), null, registerServices);
//    }
//
//    /**
//     * @param monitor
//     * @param server
//     * @param registerServices
//     * @return
//     * @throws Layer0MissingException
//     * @throws IOException
//     */
//    static ISessionContext getSessionContext(IProgressMonitor monitor, ServerAddress address, boolean registerServices)
//    throws DatabaseException, IOException
//    {
//        return getSessionContext(monitor, address, null, registerServices);
//    }
//
//    /**
//     * @param monitor
//     * @param info
//     * @param registerServices
//     * @return a database session context
//     * @throws Layer0MissingException if the layer0 ontology in the database is
//     *         not compatible with this program or it does not exist
//     * @throws IOException
//     */
//    static ISessionContext getSessionContext(IProgressMonitor monitor, final ServerAddress address, UserAuthenticator auth, boolean registerServices)
//    throws DatabaseException, IOException
//    {
//        return getSessionContext(monitor, address, auth, registerServices, false);
//    }
//
//    /**
//     * @param monitor
//     * @param address
//     * @param auth
//     * @param registerServices
//     * @param forceReload
//     * @return a database session context
//     * @throws Layer0MissingException if the layer0 ontology in the database is
//     *         not compatible with this program or it does not exist
//     * @throws IOException
//     */
//    static synchronized ISessionContext getSessionContext(IProgressMonitor monitor, final ServerAddress address, UserAuthenticator auth, boolean registerServices, boolean forceReload)
//    throws DatabaseException, IOException
//    {
//        if(!forceReload) {
//            ISessionContext newCtx = SimanticsUI.getSessionContext();
//            if (newCtx != null && address.equals(newCtx.getAddress()))
//                return newCtx;
//
//            //        for (ISessionContextProvider provider : SimanticsUI.getProviderSource().getAll()) {
//            //            ISessionContext ctx = provider.getSessionContext();
//            //            if (ctx != null && address.equals(ctx.getAddress()))
//            //                return ctx;s
//            //        }
//
//            ISessionContext cachedCtx = releaseFromCache(address);
//            if (cachedCtx != null) {
//                if (registerServices && cachedCtx instanceof SessionContext) {
//                    safeRegisterServices((SessionContext) cachedCtx);
//                }
//                return cachedCtx;
//            }
//        }
//
//        if (monitor != null)
//            monitor.subTask("Connecting to database at " + address);
//
//        boolean success = false;
//        boolean lastFailed = false;
//
//        SessionContext ctx = null;
//        UserAuthenticationAgent agent = null;
//        if (auth != null)
//            agent = UserAuthenticationAgents.staticAgent(auth);
//
//        while (!success) {
//            final DataContainer<LoginModel> loginModel = new DataContainer<LoginModel>();
//            final DataContainer<ServerInfo> serverInfo = new DataContainer<ServerInfo>();
//
//            if (agent == null) {
//                final boolean forceQuery = lastFailed;
//                agent = new UserAuthenticationAgent() {
//                    @Override
//                    public UserAuthenticator getAuthenticator(final ServerInformation information) throws IOException {
//                        final DataContainer<UserAuthenticator> authenticator = new DataContainer<UserAuthenticator>();
//                        serverInfo.set(new ServerInfo("", address, information));
//
//                        ThreadUtils.syncExec(SWTThread.getThreadAccess(Display.getDefault()), new Runnable() {
//                            @Override
//                            public void run() {
//                                LoginModel model = AuthenticationUtils.queryAuthenticationInfo(Display.getDefault().getActiveShell(), serverInfo.get(), forceQuery);
//                                if (model != null) {
//                                    loginModel.set(model);
//                                    authenticator.set(UserAuthenticators.byNameAndPassword(model.getName(), model.getPassword()));
//                                }
//                            }
//                        });
//
//                        if (authenticator.get() == null)
//                            throw new LoginCancelledException("User authentication was not provided.");
//                        return authenticator.get();
//                    }
//                };
//            }
//
//            try {
//                ctx = SessionContext.openAndInitializeSession(address, agent);
//                success = true;
//
//                LoginModel lm = loginModel.get();
//                if (lm != null && lm.isRemember() && !lm.isLoadedFromStore()) {
//                    // Only remember credentials if they were actually given and the login was successful.
//                    AuthenticationUtils.storeAuthenticationInfo(serverInfo.get(), lm);
//                }
//
//            } catch (IOException e) {
//                lastFailed = true;
//
//                Throwable cause = e.getCause();
//                if(cause instanceof InvalidAuthenticationException) {
//                    agent = null;
//                } else if(cause instanceof InvalidUserException) {
//                    agent = null;
//                } else {
//                    throw e;
//                }
//            } catch (DatabaseException e) {
//                e.printStackTrace();
//                throw e;
//            }
//        }
//
//        // [Tuukka] Removed to remove the last reference to UndoCoreManager.
//        //ctx.setServerActivation(UndoCoreManager.getManager().peekActivation(address));
//
//        if (registerServices) {
//            if (monitor != null)
//                monitor.subTask("Registering session services");
//            safeRegisterServices(ctx);
//        }
//        ISessionContext newCtx = ctx;
//
//        return newCtx;
//    }
//
//    private static void safeRegisterServices(final SessionContext ctx) {
//        SafeRunner.run(new ISafeRunnable() {
//            @Override
//            public void handleException(Throwable exception) {
//                Activator.getDefault().getLog().log(
//                        new Status(IStatus.ERROR, Activator.PLUGIN_ID,
//                                "Database session service registration produced unexpected error", exception));
//            }
//            @Override
//            public void run() {
//                ctx.registerServices();
//            }
//        });
//    }
//
//    /**
//     * Replace the existing ISessionContext in SimanticsUI with the specified
//     * <code>newContext</code> and release the previous session with the
//     * default hold time.
//     * 
//     * @param newContext the new UI database context
//     */
//    static synchronized void replaceUISession(ISessionContext newContext) {
//        ISessionContext oldContext = SimanticsUI.setSessionContext(newContext);
//        if (oldContext != null) {
//            releaseUnusedSessionAfterHoldTime(oldContext);
//        }
//    }

}
