package org.simantics.tests.modelled.ui;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TreeColumn;
import org.simantics.scl.compiler.module.coverage.Coverage;

class CoverageViewSorter extends ViewerComparator {

    private final TreeViewer viewer;

    public CoverageViewSorter(TreeViewer viewer) {
        this.viewer = viewer;
    }

    private Map<TreeColumn, Integer> columns = new HashMap<>();
    private int currentDirection;
    
    void addColumn(final TreeViewerColumn viewerColumn, final int columnidx) {
        final TreeColumn column = viewerColumn.getColumn();
        setSortColumnAndDirection(column, SWT.UP);
        column.addSelectionListener(new SelectionListener() {

            public void widgetSelected(SelectionEvent e) {
                TreeColumn current = column.getParent().getSortColumn();
                if (current.equals(column)) {
                    int sortDirection = column.getParent().getSortDirection();
                    setSortColumnAndDirection(column, sortDirection != SWT.DOWN ? SWT.DOWN : SWT.UP);
                } else {
                    setSortColumnAndDirection(column, SWT.DOWN);
                }
                viewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        columns.put(column, columnidx);
    }

    private void setSortColumnAndDirection(TreeColumn sortColumn, int direction) {
        currentDirection = direction;
        sortColumn.getParent().setSortColumn(sortColumn);
        sortColumn.getParent().setSortDirection(direction);
    }

    
    @Override
    public int compare(Viewer viewer, Object e1, Object e2) {

        TreeViewer v = (TreeViewer) viewer;
        TreeColumn currentColumn = v.getTree().getSortColumn();
        
        int res = 0;
        if (e1 instanceof Coverage && e2 instanceof Coverage) {
            Coverage c1 = (Coverage) e1;
            Coverage c2 = (Coverage) e2;
            
            int indx = columns.get(currentColumn);
            switch (indx) {
            case STSTestRunnerView.COLUMN_ELEMENT:
                res = c1.getIdentifier().compareToIgnoreCase(c2.getIdentifier());
                break;
            case STSTestRunnerView.COLUMN_RATIO:
                res = Double.compare(c1.getCoverage(), c2.getCoverage());
                break;
            case STSTestRunnerView.COLUMN_COVERED:
                res = (int) (c1.getCoveredCodeSize() - c2.getCoveredCodeSize());
                break;
            case STSTestRunnerView.COLUMN_MISSED:
                res = (int) (c1.getMissedCodeSize()) - c2.getMissedCodeSize();
                break;
            case STSTestRunnerView.COLUMN_TOTAL:
                res = (int) (c1.getTotalCodeSize() - c2.getTotalCodeSize());
                break;
            }
            if (res == 0) {
                res = c1.getIdentifier().compareTo(c2.getIdentifier());
            } else {
                res = isReverseSort() ? -res : res;
            }
        }
        return res;
    }

    private boolean isReverseSort() {
        return currentDirection == SWT.DOWN;
    }
}
