package org.simantics.tests.modelled.ui.ontology;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class TestsUIResource {
    
    public final Resource BrowseContext;
    public final Resource BrowseContext_STSSuiteSorterRule;
    public final Resource BrowseContext_TestImageRule;
    public final Resource Contributions;
    public final Resource Contributions_NewSTSSuite;
    public final Resource Contributions_NewSTSTest;
    public final Resource Contributions_STSSuites;
    public final Resource Contributions_STSTests;
    public final Resource Contributions_STSVariables;
    public final Resource Contributions_SuiteImage;
    public final Resource Contributions_VariableImage;
    public final Resource ModelingActionContext;
    public final Resource ModelingActionContext_Actions;
    public final Resource ModelingActionContext_Actions_IgnoreSTSTest;
    public final Resource ModelingActionContext_Actions_NewSTSSuite;
    public final Resource ModelingActionContext_Actions_NewSTSTest;
    public final Resource ModelingActionContext_Actions_NewSTSVariable;
    public final Resource ModelingActionContext_Actions_RunSTSTest;
    public final Resource SCLMain;
    public final Resource testIgnoredImage;
    public final Resource testImage;
    public final Resource testSuiteImage;
        
    public static class URIs {
        public static final String BrowseContext = "http://www.simantics.org/TestsUI-1.0/BrowseContext";
        public static final String BrowseContext_STSSuiteSorterRule = "http://www.simantics.org/TestsUI-1.0/BrowseContext/STSSuiteSorterRule";
        public static final String BrowseContext_TestImageRule = "http://www.simantics.org/TestsUI-1.0/BrowseContext/TestImageRule";
        public static final String Contributions = "http://www.simantics.org/TestsUI-1.0/Contributions";
        public static final String Contributions_NewSTSSuite = "http://www.simantics.org/TestsUI-1.0/Contributions/NewSTSSuite";
        public static final String Contributions_NewSTSTest = "http://www.simantics.org/TestsUI-1.0/Contributions/NewSTSTest";
        public static final String Contributions_STSSuites = "http://www.simantics.org/TestsUI-1.0/Contributions/STSSuites";
        public static final String Contributions_STSTests = "http://www.simantics.org/TestsUI-1.0/Contributions/STSTests";
        public static final String Contributions_STSVariables = "http://www.simantics.org/TestsUI-1.0/Contributions/STSVariables";
        public static final String Contributions_SuiteImage = "http://www.simantics.org/TestsUI-1.0/Contributions/SuiteImage";
        public static final String Contributions_VariableImage = "http://www.simantics.org/TestsUI-1.0/Contributions/VariableImage";
        public static final String ModelingActionContext = "http://www.simantics.org/TestsUI-1.0/ModelingActionContext";
        public static final String ModelingActionContext_Actions = "http://www.simantics.org/TestsUI-1.0/ModelingActionContext/Actions";
        public static final String ModelingActionContext_Actions_IgnoreSTSTest = "http://www.simantics.org/TestsUI-1.0/ModelingActionContext/Actions/IgnoreSTSTest";
        public static final String ModelingActionContext_Actions_NewSTSSuite = "http://www.simantics.org/TestsUI-1.0/ModelingActionContext/Actions/NewSTSSuite";
        public static final String ModelingActionContext_Actions_NewSTSTest = "http://www.simantics.org/TestsUI-1.0/ModelingActionContext/Actions/NewSTSTest";
        public static final String ModelingActionContext_Actions_NewSTSVariable = "http://www.simantics.org/TestsUI-1.0/ModelingActionContext/Actions/NewSTSVariable";
        public static final String ModelingActionContext_Actions_RunSTSTest = "http://www.simantics.org/TestsUI-1.0/ModelingActionContext/Actions/RunSTSTest";
        public static final String SCLMain = "http://www.simantics.org/TestsUI-1.0/SCLMain";
        public static final String testIgnoredImage = "http://www.simantics.org/TestsUI-1.0/testIgnoredImage";
        public static final String testImage = "http://www.simantics.org/TestsUI-1.0/testImage";
        public static final String testSuiteImage = "http://www.simantics.org/TestsUI-1.0/testSuiteImage";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public TestsUIResource(ReadGraph graph) {
        BrowseContext = getResourceOrNull(graph, URIs.BrowseContext);
        BrowseContext_STSSuiteSorterRule = getResourceOrNull(graph, URIs.BrowseContext_STSSuiteSorterRule);
        BrowseContext_TestImageRule = getResourceOrNull(graph, URIs.BrowseContext_TestImageRule);
        Contributions = getResourceOrNull(graph, URIs.Contributions);
        Contributions_NewSTSSuite = getResourceOrNull(graph, URIs.Contributions_NewSTSSuite);
        Contributions_NewSTSTest = getResourceOrNull(graph, URIs.Contributions_NewSTSTest);
        Contributions_STSSuites = getResourceOrNull(graph, URIs.Contributions_STSSuites);
        Contributions_STSTests = getResourceOrNull(graph, URIs.Contributions_STSTests);
        Contributions_STSVariables = getResourceOrNull(graph, URIs.Contributions_STSVariables);
        Contributions_SuiteImage = getResourceOrNull(graph, URIs.Contributions_SuiteImage);
        Contributions_VariableImage = getResourceOrNull(graph, URIs.Contributions_VariableImage);
        ModelingActionContext = getResourceOrNull(graph, URIs.ModelingActionContext);
        ModelingActionContext_Actions = getResourceOrNull(graph, URIs.ModelingActionContext_Actions);
        ModelingActionContext_Actions_IgnoreSTSTest = getResourceOrNull(graph, URIs.ModelingActionContext_Actions_IgnoreSTSTest);
        ModelingActionContext_Actions_NewSTSSuite = getResourceOrNull(graph, URIs.ModelingActionContext_Actions_NewSTSSuite);
        ModelingActionContext_Actions_NewSTSTest = getResourceOrNull(graph, URIs.ModelingActionContext_Actions_NewSTSTest);
        ModelingActionContext_Actions_NewSTSVariable = getResourceOrNull(graph, URIs.ModelingActionContext_Actions_NewSTSVariable);
        ModelingActionContext_Actions_RunSTSTest = getResourceOrNull(graph, URIs.ModelingActionContext_Actions_RunSTSTest);
        SCLMain = getResourceOrNull(graph, URIs.SCLMain);
        testIgnoredImage = getResourceOrNull(graph, URIs.testIgnoredImage);
        testImage = getResourceOrNull(graph, URIs.testImage);
        testSuiteImage = getResourceOrNull(graph, URIs.testSuiteImage);
    }
    
    public static TestsUIResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        TestsUIResource ret = session.peekService(TestsUIResource.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new TestsUIResource(qc.getIndependentGraph(graph));
            session.registerService(TestsUIResource.class, ret);
        }
        return ret;
    }
    
    public static TestsUIResource getInstance(RequestProcessor session) throws DatabaseException {
        TestsUIResource ret = session.peekService(TestsUIResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<TestsUIResource>() {
                public TestsUIResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new TestsUIResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(TestsUIResource.class, ret);
        }
        return ret;
    }
    
}

