package org.simantics.tests.modelled.junit;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.compiler.commands.TestScriptExecutor;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;

@Deprecated
public class RuntimeSTSTestRunner extends Runner {
    
    private final String name;
    private final String code;
    private final Integer priority;
    private CommandSession session;

    public RuntimeSTSTestRunner(String name, String code, Integer priority) {
        this.name = name;
        this.code = code;
        this.priority = priority;
    }
    
    public void setCommandSession(CommandSession session) {
        this.session = session;
    }

    @Override
    public Description getDescription() {
        return Description.createTestDescription(RuntimeSTSTestRunner.class, name);
    }

    @Override
    public void run(RunNotifier notifier) {
        StringReader reade = new StringReader(code);
        BufferedReader reader = new BufferedReader(reade);
        
        SCLContext context = SCLContext.getCurrent();
        SCLReportingHandler printer = (SCLReportingHandler)context.get(SCLReportingHandler.REPORTING_HANDLER);
        SCLReportingHandler handler;
        if(printer instanceof SCLReportingHandler)
            handler = (SCLReportingHandler)printer;
        else
            handler = SCLReportingHandler.DEFAULT;
        
        try {
            if (session == null)
                session = new CommandSession(SCLOsgi.MODULE_REPOSITORY, handler);
            new TestScriptExecutor(session, reader, handler).execute();
        } catch (IOException e) {
            throw new RuntimeException(e);
        } finally {
            try {
                reader.close();
            } catch (IOException e) {
                // Ignore
            }
        }
    }

    public String getName() {
    	return name;
    }
    
    public Integer getPriority() {
        return priority;
    }

}