/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.team.ui;

import org.simantics.db.Session;
import org.simantics.db.UndoContext;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.service.ManagementSupport;
import org.simantics.db.service.UndoRedoSupport;
import org.simantics.team.ui.ChangeSetProvider;
import org.simantics.team.ui.UndoContextElement;

class UndoContentProvider
extends ChangeSetProvider
implements UndoRedoSupport.ChangeListener {
    private UndoContextElement uce;
    protected UndoRedoSupport undoRedoSupport;
    private boolean subscribed = false;

    UndoContentProvider(Session session) {
        super(session);
        this.undoRedoSupport = (UndoRedoSupport)session.getService(UndoRedoSupport.class);
        this.subscribe();
    }

    @Override
    public Object[] getElements(Object inputElement) {
        return this.getElements(this.session);
    }

    @Override
    public void dispose() {
        this.managementSupport.cancel((ManagementSupport.ChangeSetListener)this);
        this.subscribed = false;
        super.dispose();
    }

    public void onChanged() {
        if (this.viewer != null) {
            this.refresh();
        }
    }

    protected Object[] getElements(Session session) {
        try {
            UndoRedoSupport undoSupport = (UndoRedoSupport)session.getService(UndoRedoSupport.class);
            UndoContext undoContext = undoSupport.getUndoContext(session);
            if (undoContext != null) {
                this.uce = new UndoContextElement(session, undoContext);
                return this.uce.getChildren();
            }
        }
        catch (Exception e) {
            Logger.defaultLogError((Throwable)e);
        }
        return new Object[0];
    }

    @Override
    protected void subscribe() {
        super.subscribe();
        if (this.subscribed) {
            return;
        }
        if (this.undoRedoSupport == null) {
            this.undoRedoSupport = (UndoRedoSupport)this.session.getService(UndoRedoSupport.class);
        }
        this.undoRedoSupport.subscribe((UndoRedoSupport.ChangeListener)this);
        this.subscribed = true;
    }

    void removeAll() {
        UndoRedoSupport us = (UndoRedoSupport)this.session.getService(UndoRedoSupport.class);
        UndoContext uc = us.getUndoContext(this.session);
        if (uc != null) {
            uc.clear();
            this.refresh();
        }
    }
}

