/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.team.ui;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Widget;
import org.simantics.db.Session;
import org.simantics.db.service.ManagementSupport;
import org.simantics.team.ui.TreeElement;
import org.simantics.utils.ui.SWTUtils;

abstract class ChangeSetProvider
implements ITreeContentProvider,
ManagementSupport.ChangeSetListener {
    static final boolean DEBUG = false;
    protected final Session session;
    protected final ManagementSupport managementSupport;
    private boolean subscribed = false;
    protected Viewer viewer;

    ChangeSetProvider(Session session) {
        this.session = session;
        this.managementSupport = (ManagementSupport)session.getService(ManagementSupport.class);
        this.subscribe();
    }

    public abstract Object[] getElements(Object var1);

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        this.subscribe();
    }

    public void dispose() {
        this.managementSupport.cancel((ManagementSupport.ChangeSetListener)this);
        this.subscribed = false;
    }

    public void onChanged(long csid) {
        if (this.viewer != null && this.subscribed) {
            this.refresh();
        }
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TreeElement) {
            return ((TreeElement)element).hasChildren();
        }
        return false;
    }

    public Object getParent(Object element) {
        return null;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TreeElement) {
            return ((TreeElement)parentElement).getChildren();
        }
        return null;
    }

    protected void subscribe() {
        if (this.subscribed) {
            return;
        }
        this.managementSupport.subscribe((ManagementSupport.ChangeSetListener)this);
        this.subscribed = true;
    }

    protected void refresh() {
        if (this.viewer == null) {
            return;
        }
        SWTUtils.asyncExec((Widget)this.viewer.getControl(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (!ChangeSetProvider.this.viewer.getControl().isDisposed()) {
                    ChangeSetProvider.this.viewer.refresh();
                }
            }
        });
    }
}

