package org.simantics.structural2.variables;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.structural2.Functions.InterfaceResolution;

public interface VariableConnectionPointDescriptor {
	
	public boolean isFlattenedFrom(ReadGraph graph, Variable possiblyStructuralCp) throws DatabaseException;
	public Variable getVariable(ReadGraph graph) throws DatabaseException;
	public Resource getConnectionPointResource(ReadGraph graph) throws DatabaseException;
	public String getURI(ReadGraph graph) throws DatabaseException;
	public Collection<InterfaceResolution> getInterfaceDescription(ReadGraph graph) throws DatabaseException;
	public boolean isLeaf(ReadGraph graph) throws DatabaseException;
	public boolean hasClassification(ReadGraph graph, String classification) throws DatabaseException;
	public String getRelativeRVI(ReadGraph graph, Variable base) throws DatabaseException;
	
}