package org.simantics.structural2.scl.procedural;

import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.RuntimeEnvironmentRequest;
import org.simantics.scl.compiler.environment.specification.EnvironmentSpecification;
import org.simantics.scl.compiler.runtime.RuntimeEnvironment;
import org.simantics.structural2.scl.ComponentTypeProperty;
import org.simantics.structural2.scl.ReadComponentTypeConnectionsRequest;
import org.simantics.structural2.scl.ReadComponentTypeInterfaceRequest;

public class ProceduralComponentTypeCompilationContextRequest extends UnaryRead<Resource,ProceduralComponentTypeCompilationContext> {

    public ProceduralComponentTypeCompilationContextRequest(Resource parameter) {
        super(parameter);
    }

    @Override
    public ProceduralComponentTypeCompilationContext perform(ReadGraph graph)
            throws DatabaseException {
        Resource indexRoot = graph.syncRequest(new IndexRoot(parameter));
        RuntimeEnvironment runtimeEnvironment = graph.syncRequest(new RuntimeEnvironmentRequest(indexRoot) {
            @Override
            protected void fillEnvironmentSpecification(
                    EnvironmentSpecification environmentSpecification) {
                environmentSpecification.importModule("Structural/Procedural", "");
            }
        });
        Map<String, ComponentTypeProperty> propertyMap =
                graph.syncRequest(new ReadComponentTypeInterfaceRequest(parameter, runtimeEnvironment.getEnvironment()),
                        TransientCacheListener.<Map<String, ComponentTypeProperty>>instance());
        Map<String, Resource> connectionPointMap =
                graph.syncRequest(new ReadComponentTypeConnectionsRequest(parameter),
                        TransientCacheListener.<Map<String, Resource>>instance());
        return new ProceduralComponentTypeCompilationContext(runtimeEnvironment, propertyMap, connectionPointMap);
    }
    
}
