/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural2.queries;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.TransientResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.request.RequestFlags;
import org.simantics.db.service.QueryControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gnu.trove.map.hash.THashMap;

public class ConnectionPointMapOfResource extends TransientResourceRead<Map<String, Resource>> {

    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionPointMapOfResource.class);

	public ConnectionPointMapOfResource(ReadGraph graph, Resource resource) throws DatabaseException {
	    super(graph, resource);
	}
	
	public ConnectionPointMapOfResource(ReadGraph graph, QueryControl qc, Resource resource) throws DatabaseException {
		super(graph, qc, resource);
	}

	@Override
	public Map<String,Resource> perform(ReadGraph graph, Resource resource) throws DatabaseException {
	    
		Collection<Resource> predicates = graph.getPredicates(resource);
		
		THashMap<String,Resource> result = null;
		
		for(Resource predicate : predicates) {
			
			PropertyInfo info = graph.syncRequest(new PossibleConnectionPointInfo(predicate), TransientCacheAsyncListener.<PropertyInfo>instance());
			if(info != null) {
				if (result == null) result = new THashMap<String,Resource>(predicates.size());
				if (result.put(info.name, predicate) != null)
				    LOGGER.error("The database contains siblings with the same name " + info.name + " (resource=$" + resource.getResourceId() + ").");
			}				
			
		}

		if(result != null) return result;
		
		else return Collections.emptyMap();
			
	}
	
	@Override
	public int getType() {
		return RequestFlags.INVALIDATE;
	}
	
}
