/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural2.modelingRules;

import org.eclipse.core.runtime.Platform;
import org.simantics.structural2.internal.Activator;

/**
 * @author Tuukka Lehtonen
 */
public final class Policy {

    public static boolean DEBUG                         = false;

    public static boolean DEBUG_STANDARD_MODELING_RULES = false;

    public static boolean DEBUG_CONNECTION_CONSTRAINTS  = false;

    static {
        if (Activator.getDefault().isDebugging()) {
            DEBUG = true;
            String sTrue = Boolean.TRUE.toString();

            DEBUG_STANDARD_MODELING_RULES = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/modelingrules/standard")); //$NON-NLS-1$
            DEBUG_CONNECTION_CONSTRAINTS = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/modelingrules/connectionConstraints")); //$NON-NLS-1$
        }
    }

}
