/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural.ui.modelBrowser.contributions;

import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.SWT;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.model.labeldecorators.LabelDecorationRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.operation.Layer0X;
import org.simantics.simulation.ontology.SimulationResource;

/**
 * @author Tuukka Lehtonen
 */
public enum RunLabelDecorationRule implements LabelDecorationRule {

    INSTANCE;

    public static RunLabelDecorationRule get() {
        return INSTANCE;
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    @Override
    public LabelDecorator getLabelDecorator(ReadGraph graph, Object content) throws DatabaseException {
        Resource run = (Resource) content;

        Resource model = graph.syncRequest(new PossibleModel(run));
        if (model == null)
            return null;
        if (!graph.hasStatement(model, Layer0X.getInstance(graph).IsActivatedBy))
            return null;
        if (!graph.hasStatement(run, SimulationResource.getInstance(graph).IsActive))
            return null;

        return new LabelDecorator.Stub() {
            @Override
            public String decorateLabel(String label, String column, int itemIndex) {
                return label + " [ACTIVE]";
            }
            @SuppressWarnings("unchecked")
            @Override
            public <F> F decorateFont(F font, String column, int itemIndex) {
                return (F) ((FontDescriptor) font).withStyle(SWT.BOLD);
            }
        };
    }

}
