/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural.ui.modelBrowser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

import org.eclipse.swt.widgets.Composite;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.browsing.ui.model.dnd.DndBrowseContext;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;
import org.simantics.project.ontology.ProjectResource;
import org.simantics.ui.SimanticsUI;

/**
 * @author Hannu Niemist&ouml;
 */
public class ModelBrowser2 extends ModelBrowser {

    final static public Set<String> defaultBrowseContexts = Collections.singleton(ProjectResource.URIs.ProjectBrowseContext);
    volatile DndBrowseContext dndBrowseContext;

    public ModelBrowser2() {
        // As long as these are not useful, don't shown them by default.
        this.hideComparatorSelector = true;
        this.hideViewpointSelector = true;

        SimanticsUI.getSession().asyncRequest(new ReadRequest() {
            @Override
            public void run(ReadGraph graph) throws DatabaseException { 
                ArrayList<Resource> browseContexts = new ArrayList<Resource>();
                for (String uri : getBrowseContexts()) {
                    Resource browseContext = graph.getPossibleResource(uri);
                    if (browseContext != null)
                        browseContexts.add(browseContext);
                }
                try {
                    dndBrowseContext = DndBrowseContext.create(graph, browseContexts);
                } catch (InvalidContribution e) {
                    ErrorLogger.defaultLogError(e);
                }
            }
        });
    }

    @Override
    public void createPartControl(Composite parent) {
        this.propertyBrowseContexts = loadBrowseContexts(getBrowseContexts());
        super.createPartControl(parent);
    }

    @Override
    protected Set<String> getBrowseContexts() {
        return defaultBrowseContexts;
    }

    @Override
    protected void handleDrop(final Object data, final NodeContext target) {
        if (target == null)
            return;

        SimanticsUI.getSession().asyncRequest(new Read<Runnable>() {
            @Override
            public Runnable perform(ReadGraph graph) throws DatabaseException {
                if (dndBrowseContext == null)
                    return null;
                return dndBrowseContext.getAction(graph, target, data);
            }
        }, new Procedure<Runnable>() {
            @Override
            public void execute(Runnable result) {
                if (result != null)
                    result.run();
            }

            @Override
            public void exception(Throwable t) {
                ErrorLogger.defaultLogError(t);
            }
        });
    }
    
    protected DndBrowseContext getDndBrowseContext() {
		return dndBrowseContext;
	}

}
