/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural.ui.compositeViewer;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.structural.ui.modelBrowser.nodes.CompositeNode;
import org.simantics.ui.workbench.ResourceEditorInput;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.utils.ui.AdaptionUtils;

public class CompositeViewerAdapter extends AbstractResourceEditorAdapter {

	public CompositeViewerAdapter() {
		super("Composite Viewer", null, 10);
	}	

	@Override
	public boolean canHandle(ReadGraph g, Object input)
			throws DatabaseException {
		NodeContext context = AdaptionUtils.adaptToSingle(input, NodeContext.class);
		if(context != null) {
			Object obj = context.getConstant(BuiltinKeys.INPUT);
			if(obj instanceof CompositeNode) {
				return true;
			}
		}
		return false;
	}	
	
	@Override
	public void openEditor(Resource r) throws Exception {
		String editorId = "org.simantics.structural.ui.compositeViewer";
		openEditorWithId(editorId, new ResourceEditorInput(editorId, r));
	}
	
}
