/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural.ui.compositeViewer;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Composite;
import org.simantics.db.procedure.Listener;
import org.simantics.graphviz.Graph;
import org.simantics.graphviz.ui.GraphvizComponent;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.workbench.ResourceEditorPart;

public class CompositeViewer extends ResourceEditorPart {

    GraphvizComponent component;
    private boolean disposed = false;

    @Override
    public void createPartControl(Composite parent) {
        component = new GraphvizComponent(parent, 0);
        component.waitUntilInitialized();
        readGraph();
    }

    private void readGraph() {
        SimanticsUI.getSession().asyncRequest(new CreateCompositeGraph(
                getResourceInput().getResource()),
                new Listener<Graph>() {

            @Override
            public void exception(Throwable e) {
                e.printStackTrace();
            }

            @Override
            public void execute(final Graph graph) {
                Job job = new Job("Layout composite graph") {

                    @Override
                    protected IStatus run(IProgressMonitor monitor) {
                        component.setGraph(graph, "neato");
                        return Status.OK_STATUS;
                    }

                };
                job.schedule();
            }

            @Override
            public boolean isDisposed() {
                return disposed;
            }
        });
    }

    @Override
    public void setFocus() {
        if (component != null && !component.isDisposed()) {
            component.setFocus();
            component.requestFocus();
        }
    }

    @Override
    public void dispose() {
        disposed  = true;
    }

}
