package org.simantics.spreadsheet.ui;

import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.MouseInputAdapter;
import java.awt.*;
import java.awt.event.MouseEvent;

public class TableRowResizer extends MouseInputAdapter
{ 
    public static Cursor resizeCursor = Cursor.getPredefinedCursor(Cursor.N_RESIZE_CURSOR); 

    private int mouseYOffset, resizingRow; 
    private Cursor otherCursor = resizeCursor; 
    private JTable table; 

    public TableRowResizer(JTable table){ 
        this.table = table; 
        table.addMouseListener(this); 
        table.addMouseMotionListener(this); 
    } 

    private int getResizingRow(Point p){ 
        return getResizingRow(p, table.rowAtPoint(p)); 
    } 

    private int getResizingRow(Point p, int row){ 
        if(row == -1){ 
            return -1; 
        } 
        int col = table.columnAtPoint(p); 
        if(col==-1) 
            return -1; 
        Rectangle r = table.getCellRect(row, col, true); 
        r.grow(0, -3); 
        if(r.contains(p)) 
            return -1; 

        int midPoint = r.y + r.height / 2; 
        int rowIndex = (p.y < midPoint) ? row - 1 : row; 

        return rowIndex; 
    } 

    public void mousePressed(MouseEvent e){ 
        Point p = e.getPoint(); 

        resizingRow = getResizingRow(p); 
        mouseYOffset = p.y - table.getRowHeight(resizingRow); 
    } 

    private void swapCursor(){ 
        Cursor tmp = table.getCursor(); 
        table.setCursor(otherCursor); 
        otherCursor = tmp; 
    }

    public void mouseMoved(MouseEvent e){
        if((getResizingRow(e.getPoint())>=0)
           != (table.getCursor() == resizeCursor)){
            swapCursor();
        }
    }

    private boolean dragging = false;
    
    public void mouseDragged(MouseEvent e){
        int mouseY = e.getY();

        if(resizingRow >= 0){
            int newHeight = mouseY - mouseYOffset;
            if(newHeight > 0) {
                table.setRowHeight(resizingRow, newHeight);
            }
        }
        dragging = true;
    }
    
   @Override
   public void mouseReleased(MouseEvent e) {
       if (dragging) {
           int mouseY = e.getY();
           int newHeight = mouseY - mouseYOffset;
           System.out.println(newHeight);
           onResize(resizingRow, newHeight);
           dragging = false;
       }
   }
    
    public void onResize(int row, int height) {
    	
    }
    
}