/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.spreadsheet.ui;

import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.synchronization.graph.ElementWriter;
import org.simantics.g2d.element.IElement;
import org.simantics.spreadsheet.resource.SpreadsheetResource;

public class SheetWriter implements ElementWriter {

    public static final Object LABEL = new Object();

    @Override
    public void addToGraph(WriteGraph g, IElement element, Resource elementResource) throws DatabaseException {

        final Resource sheetComponent = element.getHint(SheetClass.KEY_SHEET);
        final String rvi = element.getHint(SheetClass.KEY_RVI);

        if (sheetComponent == null)
            throw new IllegalArgumentException("KEY_SHEET hint not set");

        if (rvi == null)
            throw new IllegalArgumentException("KEY_RVI hint not set");

        SpreadsheetResource sr = SpreadsheetResource.getInstance(g);

        g.claim(elementResource, sr.HasSheet, sheetComponent);
        g.claimLiteral(elementResource, sr.HasRVI, rvi, Bindings.STRING);

    }

    @Override
    public void removeFromGraph(WriteGraph graph, Resource elementResource) throws DatabaseException {
    }

}
