package org.simantics.spreadsheet.ui;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Component;
import java.awt.Color;

import javax.swing.Icon;
import javax.swing.border.EmptyBorder;

import org.simantics.ui.colors.Colors;

public class SheetBorder extends EmptyBorder
{
	private static final long serialVersionUID = 1L;
	protected boolean bottomColor;
	protected boolean rightColor;
	
	final Color NONE = Colors.awt(Colors.rgb(0.9,0.9,0.9));
	


    /**
     * Creates a matte border with the specified insets and color.
     * @param top the top inset of the border
     * @param left the left inset of the border
     * @param bottom the bottom inset of the border
     * @param right the right inset of the border
     * @param matteColor the color rendered for the border
     */
    public SheetBorder(int top, int left, int bottom, int right, boolean bottomColor, boolean rightColor)   {
        super(top, left, bottom, right);
        this.bottomColor = bottomColor;
        this.rightColor = rightColor;
    }

    /**
     * Paints the matte border.
     */
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
    	
        Insets insets = getBorderInsets(c);
        Color oldColor = g.getColor();
        g.translate(x, y);

        boolean same = bottomColor == rightColor;
        
        if(same) {
        	
        	g.setColor(bottomColor ? Color.BLACK : NONE);
        	g.fillRect(0, height - insets.bottom, 2 + width - insets.left, insets.bottom);
        	g.fillRect(width - insets.right, 0, insets.right, height - insets.bottom + 2);
        	
        } else {
        
        	// Not the same color - paint black on top

        	if(bottomColor) {
        		// Black bottom - no right
        		g.setColor(NONE);
        		g.fillRect(width - insets.right, 0, insets.right, height - insets.bottom + 2);
        		g.setColor(Color.BLACK);
        		g.fillRect(0, height - insets.bottom, 2 + width - insets.left, insets.bottom);
        	} else {
        		// Black right - no bottom
        		g.setColor(NONE);
        		g.fillRect(0, height - insets.bottom, 2 + width - insets.left, insets.bottom);
        		g.setColor(Color.BLACK);
        		g.fillRect(width - insets.right, 0, insets.right, height - insets.bottom + 2);
        	}
        
        }
        
        g.translate(-x, -y);
        g.setColor(oldColor);

    }

    /**
     * Reinitialize the insets parameter with this Border's current Insets.
     * @param c the component for which this border insets value applies
     * @param insets the object to be reinitialized
     * @since 1.3
     */
    public Insets getBorderInsets(Component c, Insets insets) {
        return computeInsets(insets);
    }

    /**
     * Returns the insets of the border.
     * @since 1.3
     */
    public Insets getBorderInsets() {
        return computeInsets(new Insets(0,0,0,0));
    }

    /* should be protected once api changes area allowed */
    private Insets computeInsets(Insets insets) {
    	insets.left = left;
    	insets.top = top;
    	insets.right = right;
    	insets.bottom = bottom;
        return insets;
    }

    /**
     * Returns the color used for tiling the border or null
     * if a tile icon is being used.
     * @since 1.3
     */
    public Color getMatteColor() {
        return NONE;
    }

   /**
     * Returns the icon used for tiling the border or null
     * if a solid color is being used.
     * @since 1.3
     */
    public Icon getTileIcon() {
        return null;
    }

    /**
     * Returns whether or not the border is opaque.
     */
    public boolean isBorderOpaque() {
        // If a tileIcon is set, then it may contain transparent bits
        return true;
    }

}
