package org.simantics.spreadsheet.ui;

import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.spreadsheet.Adaptable;
import org.simantics.spreadsheet.ClientModel;
import org.simantics.spreadsheet.util.SpreadsheetUtils;
import org.simantics.utils.ui.jface.ActiveSelectionProvider;
import org.simantics.ui.selection.VariableWorkbenchSelectionElement;

public class SelectionListener implements ListSelectionListener {

	final JTable table;
	final JTextField expression;
	final ExpressionTextListener etl;
	final ActiveSelectionProvider selectionProvider;
	final Adaptable serverModel;
	final ClientModel clientModel;

	// It is necessary to keep the table since it is not possible
	// to determine the table from the event's source
	SelectionListener(JTable table, JTextField expression, ExpressionTextListener etl, ActiveSelectionProvider selectionProvider, Adaptable serverModel, ClientModel clientModel) {
		assert(table != null);
		assert(selectionProvider != null);
		this.table = table;
		this.expression = expression;
		this.etl = etl;
		this.selectionProvider = selectionProvider;
		this.serverModel = serverModel;
		this.clientModel = clientModel;
	}

	public void valueChanged(ListSelectionEvent e) {

		final int[] selectedColumns = table.getSelectedColumns();
		final int[] selectedRows = table.getSelectedRows();

		if(selectedColumns.length == 1 && selectedRows.length == 1) {

			final TableSelection tableSelection = new TableSelection() {

				@Override
				public int[] getColumns() {
					return selectedColumns;
				}

				@Override
				public int[] getRows() {
					return selectedRows;
				}

			};

			final Variable sheet = serverModel.getAdapter(Variable.class);

			final Object cell = table.getValueAt(selectedRows[0], selectedColumns[0]);
			if(cell != null) {

				String expression = "";

				Object expressionO = clientModel.getPossiblePropertyAt(SpreadsheetUtils.cellName(selectedRows[0], selectedColumns[0]), ClientModel.CONTENT_EXPRESSION);
				if(expressionO instanceof String) {
					expression = (String)expressionO;
				} else if(expressionO instanceof Variant) {
					expression = ((Variant)expressionO).toString();
				}

				if(expression == null) {
					Variant content = SpreadsheetUtils.getSafeClientVariant(clientModel, SpreadsheetUtils.cellName(selectedRows[0], selectedColumns[0]), ClientModel.CONTENT);
					if(content != null)
						expression =  content.getValue().toString();
					else
						expression = "";
				} else {
					expression = "=" + expression;
				}
				if (this.etl != null) {
					if(expression != null) {
						SelectionListener.this.etl.setCell(expression, selectedRows[0], selectedColumns[0]);
					} else {
						SelectionListener.this.etl.setCell("", -1, -1);
					}
				}

				Display.getDefault().asyncExec(new Runnable() {
					@Override
					public void run() {

						if(sheet != null) {
							selectionProvider.setSelection(new StructuredSelection(new VariableWorkbenchSelectionElement(sheet)));
						} else {
							selectionProvider.setSelection(new StructuredSelection(new Object[] { cell, "", tableSelection}));
						}

					}
				});
			} else {

				Display.getDefault().asyncExec(new Runnable() {

					@Override
					public void run() {

						if(selectionProvider == null) return;

						if(sheet != null) {
							selectionProvider.setSelection(new StructuredSelection(new Object[] { sheet, "", tableSelection}));
						} else {
							selectionProvider.setSelection(new StructuredSelection(new Object[] { "", "", tableSelection}));
						}

					}

				});

			}
		}

		if (e.getValueIsAdjusting()) {
			// The mouse button has not yet been released
		}

	}

}
