/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.spreadsheet.resource.SpreadsheetResource;

public class Sheets
extends VariableRead<List<String>> {
    public Sheets(Variable variable) {
        super(variable);
    }

    public List<String> perform(ReadGraph graph) throws DatabaseException {
        Resource book = this.variable.getParent(graph).getRepresents(graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Collection sheets = (Collection)graph.syncRequest((Read)new ObjectsWithType(book, L0.ConsistsOf, SpreadsheetResource.getInstance((ReadGraph)graph).Spreadsheet));
        ArrayList<String> result = new ArrayList<String>(sheets.size());
        sheets.forEach(sheet -> {
            try {
                String name = (String)graph.getPossibleRelatedValue(sheet, layer0.HasName, (Binding)Bindings.STRING);
                result.add(name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return result;
    }
}

