package org.simantics.spreadsheet.graph.synchronization;

import java.util.Collection;
import java.util.Map;

import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.spreadsheet.graph.function.LineContentBean;
import org.simantics.structural.synchronization.base.CommandBuilder;
import org.simantics.structural.synchronization.base.ModuleUpdateContext;
import org.simantics.structural.synchronization.base.ModuleUpdaterBase;
import org.simantics.structural.synchronization.base.PropertyUpdateRule;
import org.simantics.structural.synchronization.base.Solver;

public class LineUpdater extends ModuleUpdaterBase<SheetLineComponent> {
	
	public LineUpdater(String id) {
		super(id);
		addPropertyUpdateRule(new PropertyUpdateRule<SheetLineComponent>() {
			
			@Override
			public String getPropertyName() {
				return "content";
			}
			
			@Override
			public void apply(ModuleUpdateContext<SheetLineComponent> context, boolean isCreating,
					Map<String, Variant> propertyMap, Map<String, Collection<String>> connectionMap, Variant value) {
				
				LineCommandBuilder builder = context.<LineCommandBuilder>getConcreteCommand();
                try {
                    LineContentBean valuee = (LineContentBean) value.getValue(LineContentBean.BINDING);
                    builder.bean = valuee;
                } catch (AdaptException e) {
                    e.printStackTrace();
                } catch (ClassCastException e) {
                    e.printStackTrace();
                }
//				if (valuee instanceof LineContentBean)
//			    
//			else
//			    System.err.println("valuee is instanceof " + valuee.getClass().getSimpleName() + " " + valuee);
			
			}
			
		});
	}

	@Override
	public CommandBuilder createAddCommandBuilder(String name) {
		return new LineCommandBuilder(name, false);
	}

	@Override
	public CommandBuilder createUpdateCommandBuilder(String name) {
		return new LineCommandBuilder(name, true);
	}
	
}