package org.simantics.spreadsheet.graph.adapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.ConstantChildVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableFactory;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.spreadsheet.SheetVariables;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.spreadsheet.util.SpreadsheetUtils;
import org.simantics.utils.datastructures.datatype.RGBInt8;

public class DoubleArrayCells implements VariableFactory {

	private Binding RGB = Bindings.getBindingUnchecked(RGBInt8.class);
//	private Datatype RGB = Datatypes.getDatatypeUnchecked(RGBInt8.class);
	
	private Resource configuration;
	
	public DoubleArrayCells(Resource configuration) {
		this.configuration = configuration;
	}

	final String[] propertyNames = { SheetVariables.CONTENT, SheetVariables.FOREGROUND, SheetVariables.BACKGROUND, Variables.LABEL, "immutable" }; 
	final Binding[] bindings = { Bindings.VARIANT, RGB, RGB, Bindings.STRING, Bindings.BOOLEAN };
	
	private Collection<Variable> toVariables(ReadGraph graph, Variable variable, double[] data, int width) throws DatabaseException {

		SpreadsheetResource sr = SpreadsheetResource.getInstance(graph);
		String location = graph.getPossibleRelatedValue(configuration, sr.HasLocation, Bindings.STRING);
		if(location == null) return Collections.emptyList();
		
		int rows = data.length / width;
		
		RGBInt8 fore = new RGBInt8(255, 255, 255);
		RGBInt8 back = new RGBInt8(80, 130, 190);
		
		ArrayList<Variable> result = new ArrayList<Variable>();
		for(int offset=0,i=0;i<rows;i++) {
			for(int j=0;j<width;j++) {
				double value = data[offset++];
				String valueLocation = SpreadsheetUtils.offset(location, i, j);
				result.add(new DoubleArrayCellVariable(variable, valueLocation, propertyNames, bindings, new Object[] { Variant.ofInstance(value), fore, back, configuration, String.valueOf(value), false }));
			}
		}
		return result;

	}
	
	private Collection<Variable> error(ReadGraph graph, Variable variable, String message) throws DatabaseException {

		SpreadsheetResource sr = SpreadsheetResource.getInstance(graph);
		String location = graph.getPossibleRelatedValue(configuration, sr.HasLocation, Bindings.STRING);
		if(location == null) return Collections.emptyList();
		
		return Collections.<Variable>singletonList(new ConstantChildVariable(variable, location, propertyNames, bindings, new Object[] { message })); 

	}
	
	@Override
	public Collection<Variable> evaluate(ReadGraph graph, Variable variable) throws DatabaseException {
		
		SpreadsheetResource sr = SpreadsheetResource.getInstance(graph);
		double[] data = graph.getPossibleRelatedValue(configuration, sr.DoubleArrayCell_HasDoubleArray, Bindings.DOUBLE_ARRAY);
		if(data == null) return error(graph, variable, "No double array data.");
		Integer width = graph.getPossibleRelatedValue(configuration, sr.DoubleArrayCell_HasWidth, Bindings.INTEGER);
		if(width == null) return error(graph, variable, "Invalid width for double array.");
			
		return toVariables(graph, variable, data, width);
		
	}
	
}
