/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.spreadsheet.graph.adapter;

import java.util.Map;

import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Template;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.operation.Layer0X;
import org.simantics.spreadsheet.resource.SpreadsheetResource;

public class CompositeTemplate implements Template {

    @Override
    public void apply(WriteGraph graph, Map<String, Object> parameters) throws DatabaseException {

        Layer0 l0 = Layer0.getInstance(graph);
        Layer0X L0X = Layer0X.getInstance(graph);
        SpreadsheetResource sr = SpreadsheetResource.getInstance(graph);

        Resource result = (Resource)parameters.get("");
        Resource composite = (Resource)parameters.get("composite");
        String name = (String)parameters.get("name");

        if(name == null) {
            name = GraphUtils.findFreshEscapedName(graph, "Sheet", composite, sr.HasSheet);
        }
        graph.claimLiteral(result, l0.HasName, name, Bindings.STRING);
        graph.claim(composite, sr.HasSheet, result);
        graph.claim(composite, L0X.IsRealized, result);
        graph.claim(composite, l0.ConsistsOf, l0.PartOf, result);

        //InstanceFactory sheetElementFactory = graph.adapt(sr.SpreadsheetElement, InstanceFactory.class);
        //Map<String, Object> sheetElement = graph.syncRequest(sheetElementFactory.create(graph, ArrayMap.keys("").values("")));
        //OrderedSetUtils.createExisting(graph, result, (Resource)sheetElement.get(""));
        //graph.claim((Resource)sheetElement.get(""), sr.HasSheet, result);

//        if (parameters.containsKey("exampleData")) {
////            Resource rowResource0 = graph.newResource();
////            graph.claim(rowResource0, b.InstanceOf, null, sr.Row);
//            Resource rowResource1 = graph.newResource();
//            graph.claim(rowResource1, l0.InstanceOf, null, sr.Row);
//            Resource columnResource0 = graph.newResource();
//            graph.claim(columnResource0, l0.InstanceOf, null, sr.Column);
////            Resource columnResource1 = graph.newResource();
////            graph.claim(columnResource1, b.InstanceOf, null, sr.Column);
////            Resource columnResource2 = graph.newResource();
////            graph.claim(columnResource2, b.InstanceOf, null, sr.Column);
////            Resource columnResource3 = graph.newResource();
////            graph.claim(columnResource3, b.InstanceOf, null, sr.Column);
//
////            graph.claim(result, sr.HasRows, OrderedSetUtils.create(graph, sr.Rows, rowResource0, rowResource1));
////            graph.claim(result, sr.HasColumns, OrderedSetUtils.create(graph, sr.Columns, columnResource0, columnResource1, columnResource2, columnResource3));
//            graph.claim(result, sr.HasRows, OrderedSetUtils.create(graph, sr.Rows, rowResource1));
//            graph.claim(result, sr.HasColumns, OrderedSetUtils.create(graph, sr.Columns, columnResource0));
//
//            {
//                Resource newCell = graph.newResource();
//                graph.claim(newCell, l0.InstanceOf, null, sr.DimensionsCell);
//                graph.addLiteral(newCell, l0.HasName, l0.NameOf, l0.String, "Dimensions", Bindings.STRING);
//                graph.addValue(newCell, sr.FitColumns, sr.FitColumnsOf, l0.Boolean, true, Bindings.BOOLEAN);
//                graph.addValue(newCell, sr.FitRows, sr.FitRowsOf, l0.Boolean, true, Bindings.BOOLEAN);
//                graph.claim(result, l0.ConsistsOf, l0.PartOf, newCell);
//            }
//
//            {
//                Resource newCell = graph.newResource();
//                graph.claim(newCell, l0.InstanceOf, null, sr.HeadersCell);
//                graph.addLiteral(newCell, l0.HasName, l0.NameOf, l0.String, "Headers", Bindings.STRING);
//                graph.addValue(newCell, sr.ColumnLabels, sr.ColumnLabelsOf, l0.StringArray, new String[] { "Diagram", "Name", "Length", "In Simulation" }, Bindings.getBindingUnchecked(String[].class));
//                graph.addValue(newCell, sr.ColumnWidths, sr.ColumnCountOf, l0.IntegerArray, new int[] { 180, 180, 180, 180 }, Bindings.INT_ARRAY);
//                graph.claim(result, l0.ConsistsOf, l0.PartOf, newCell);
//            }
//
//
////            {
////                Resource newCell = graph.newResource();
////                graph.claim(newCell, b.InstanceOf, null, sr.TextCell);
////                String label = "Pipe name";
////                graph.claim(newCell, sr.HasRow, sr.RowOf, rowResource0);
////                graph.claim(newCell, sr.HasColumn, sr.ColumnOf, columnResource0);
////                graph.addValue(newCell, sr.Label, sr.LabelOf, b.String, label, StringJavaBinding.INSTANCE);
////                graph.claim(result, b.ConsistsOf, b.PartOf, newCell);
////            }
////
////            {
////                Resource newCell = graph.newResource();
////                graph.claim(newCell, b.InstanceOf, null, sr.TextCell);
////                String label = "Pipe length";
////                graph.claim(newCell, sr.HasRow, sr.RowOf, rowResource0);
////                graph.claim(newCell, sr.HasColumn, sr.ColumnOf, columnResource1);
////                graph.addValue(newCell, sr.Label, sr.LabelOf, b.String, label, StringJavaBinding.INSTANCE);
////                graph.claim(result, b.ConsistsOf, b.PartOf, newCell);
////            }
////
////            {
////                Resource newCell = graph.newResource();
////                graph.claim(newCell, b.InstanceOf, null, sr.TextCell);
////                String label = "Flow area";
////                graph.claim(newCell, sr.HasRow, sr.RowOf, rowResource0);
////                graph.claim(newCell, sr.HasColumn, sr.ColumnOf, columnResource2);
////                graph.addValue(newCell, sr.Label, sr.LabelOf, b.String, label, StringJavaBinding.INSTANCE);
////                graph.claim(result, b.ConsistsOf, b.PartOf, newCell);
////            }
////
////            {
////                Resource newCell = graph.newResource();
////                graph.claim(newCell, b.InstanceOf, null, sr.TextCell);
////                String label = "In simulation";
////                graph.claim(newCell, sr.HasRow, sr.RowOf, rowResource0);
////                graph.claim(newCell, sr.HasColumn, sr.ColumnOf, columnResource3);
////                graph.addValue(newCell, sr.Label, sr.LabelOf, b.String, label, StringJavaBinding.INSTANCE);
////                graph.claim(result, b.ConsistsOf, b.PartOf, newCell);
////            }
//
//            {
//                Resource newCell = graph.newResource();
//                graph.claim(newCell, l0.InstanceOf, null, sr.ExpressionCell);
//                graph.addLiteral(newCell, l0.HasName, l0.NameOf, l0.String, "Expression", Bindings.STRING);
////                String label = "Attributes(Components('PIPE*'), '#Name', '#PI12_LENGTH', '#PI12_AREA', '#IncludedInSimulation')";
//                String label = 
//                	"nameOf v = stringPropertyOf v \"HasName\"\n" +
//                	"typeOf v = resourcePropertyOf v \"Type\"\n" +
//                	"lengthOf v = doublePropertyOf v \"PI12_LENGTH\"\n" +
//                	"module <- apply \"Components\" \"PIPE*\"\n" +
//                	"composite = browseFrom module \".\"\n" +
//                	"[(nameOf composite, nameOf module, lengthOf module)]\n";
//                
////                nameOf v = stringPropertyOf v "HasName"
////                typeOf v = resourcePropertyOf v "Type"
////                lengthOf v = doublePropertyOf v "PI12_LENGTH"
////                module <- apply "Components" "PIPE*"
////                composite = browseFrom module "."
////                [(nameOf composite, nameOf module, lengthOf module)]
//                
//                   
//                graph.claim(newCell, sr.HasRow, sr.RowOf, rowResource1);
//                graph.claim(newCell, sr.HasColumn, sr.ColumnOf, columnResource0);
//                graph.addValue(newCell, sr.Expression, sr.ExpressionOf, l0.String, label, Bindings.STRING);
//                graph.claim(result, l0.ConsistsOf, l0.PartOf, newCell);
//            }
//
//        } else if (parameters.containsKey("StreamPropertyTable")) {
//
//            Resource rowResource0 = graph.newResource();
//            graph.claim(rowResource0, l0.InstanceOf, null, sr.Row);
//            Resource columnResource0 = graph.newResource();
//            graph.claim(columnResource0, l0.InstanceOf, null, sr.Column);
//
//            graph.claim(result, sr.HasRows, OrderedSetUtils.create(graph, sr.Rows, rowResource0));
//            graph.claim(result, sr.HasColumns, OrderedSetUtils.create(graph, sr.Columns, columnResource0));
//
//            {
//                Resource newCell = graph.newResource();
//                graph.claim(newCell, l0.InstanceOf, null, sr.DimensionsCell);
//                graph.addValue(newCell, sr.FitColumns, sr.FitColumnsOf, l0.Boolean, true, Bindings.BOOLEAN);
//                graph.addValue(newCell, sr.FitRows, sr.FitRowsOf, l0.Boolean, true, Bindings.BOOLEAN);
//                graph.claim(result, l0.ConsistsOf, l0.PartOf, newCell);
//            }
//
//            {
//                Resource newCell = graph.newResource();
//                graph.claim(newCell, l0.InstanceOf, null, sr.HeadersCell);
//                graph.addValue(newCell, sr.ColumnLabels, sr.ColumnLabelsOf, l0.StringArray, new String[] { "Stream", "Property", "Value", "Source" }, Bindings.getBindingUnchecked(String[].class));
//                graph.addValue(newCell, sr.ColumnWidths, sr.ColumnCountOf, l0.IntegerArray, new int[] { 180, 180, 180 }, Bindings.INT_ARRAY);
//                graph.claim(result, l0.ConsistsOf, l0.PartOf, newCell);
//            }
//
//            {
//                Resource newCell = graph.newResource();
//                graph.claim(newCell, l0.InstanceOf, null, sr.ExpressionCell);
//                String label = "PropertyTable(Properties(Streams()), '.#HasName', 'HasName', '', 'HasSource')";
//                graph.claim(newCell, sr.HasRow, sr.RowOf, rowResource0);
//                graph.claim(newCell, sr.HasColumn, sr.ColumnOf, columnResource0);
//                graph.addValue(newCell, sr.Expression, sr.ExpressionOf, l0.String, label, Bindings.STRING);
//                graph.claim(result, l0.ConsistsOf, l0.PartOf, newCell);
//            }
//
//        } else if (parameters.containsKey("ActiveModulePropertyTable")) {
//
//            Resource rowResource0 = graph.newResource();
//            graph.claim(rowResource0, l0.InstanceOf, null, sr.Row);
//            Resource columnResource0 = graph.newResource();
//            graph.claim(columnResource0, l0.InstanceOf, null, sr.Column);
//
//            graph.claim(result, sr.HasRows, OrderedSetUtils.create(graph, sr.Rows, rowResource0));
//            graph.claim(result, sr.HasColumns, OrderedSetUtils.create(graph, sr.Columns, columnResource0));
//
//            {
//                Resource newCell = graph.newResource();
//                graph.claim(newCell, l0.InstanceOf, null, sr.DimensionsCell);
//                graph.addValue(newCell, sr.FitColumns, sr.FitColumnsOf, l0.Boolean, true, Bindings.BOOLEAN);
//                graph.addValue(newCell, sr.FitRows, sr.FitRowsOf, l0.Boolean, true, Bindings.BOOLEAN);
//                graph.claim(result, l0.ConsistsOf, l0.PartOf, newCell);
//            }
//
//            {
//                Resource newCell = graph.newResource();
//                graph.claim(newCell, l0.InstanceOf, null, sr.HeadersCell);
//                graph.addValue(newCell, sr.ColumnLabels, sr.ColumnLabelsOf, l0.StringArray, new String[] { "Unit", "Property", "Value", "Source" }, Bindings.getBindingUnchecked(String[].class));
//                graph.addValue(newCell, sr.ColumnWidths, sr.ColumnCountOf, l0.IntegerArray, new int[] { 180, 180, 180 }, Bindings.INT_ARRAY);
//                graph.claim(result, l0.ConsistsOf, l0.PartOf, newCell);
//            }
//
//            {
//                Resource newCell = graph.newResource();
//                graph.claim(newCell, l0.InstanceOf, null, sr.ExpressionCell);
//                String label = "PropertyTable(Parameters(ActiveModules()), '..#HasName', 'HasName', '', 'HasSource')";
//                graph.claim(newCell, sr.HasRow, sr.RowOf, rowResource0);
//                graph.claim(newCell, sr.HasColumn, sr.ColumnOf, columnResource0);
//                graph.addValue(newCell, sr.Expression, sr.ExpressionOf, l0.String, label, Bindings.STRING);
//                graph.claim(result, l0.ConsistsOf, l0.PartOf, newCell);
//            }
//
//        } else {
//
//            graph.claim(result, sr.HasRows, OrderedSetUtils.create(graph, sr.Rows));
//            graph.claim(result, sr.HasColumns, OrderedSetUtils.create(graph, sr.Columns));
//
//            {
//                Resource newCell = graph.newResource();
//                graph.claim(newCell, l0.InstanceOf, null, sr.DimensionsCell);
//                graph.addValue(newCell, sr.ColumnCount, sr.ColumnCountOf, l0.Integer, 10, Bindings.INTEGER);
//                graph.addValue(newCell, sr.RowCount, sr.RowCountOf, l0.Integer, 10, Bindings.INTEGER);
//                graph.addValue(newCell, sr.FitColumns, sr.FitColumnsOf, l0.Boolean, false, Bindings.BOOLEAN);
//                graph.addValue(newCell, sr.FitRows, sr.FitRowsOf, l0.Boolean, false, Bindings.BOOLEAN);
//                graph.claim(result, l0.ConsistsOf, l0.PartOf, newCell);
//            }
//
//        }

    }

}
