package org.simantics.spreadsheet.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

import org.simantics.datatypes.literal.Font;
import org.simantics.datatypes.literal.RGB;

public final class SpreadsheetStyle implements SheetNode, SpreadsheetElement<SpreadsheetStyle, SpreadsheetStyle> {

//    public static final Binding BINDING = Bindings.getBindingUnchecked(SpreadsheetStyle.class);
    
    private static final SpreadsheetStyle EMPTY = SpreadsheetStyle.newInstace().name("Style_E").build();
    
    private static final long serialVersionUID = -4969920277489585741L;
    
    public final String name;
	public final int border;
	public final int align;
	public final Font font;
	public final RGB.Integer foreground;
	public final RGB.Integer background;
	public final boolean locked;
	public final int rowSpan;
	public final int columnSpan;

	private transient int synchronizationId;
    private transient final int hashCode;

    public final String formatString;
    public final int formatIndex;
	
	public SpreadsheetStyle(String name, int border, int align2, Font font2, RGB.Integer foreground2, RGB.Integer background2, boolean locked2, int rowSpan2, int columnSpan2, String formatString, short formatIndex) {
	    this.name = name;
	    this.border = border;
	    this.align = align2;
	    this.font = font2;
	    this.foreground = foreground2;
	    this.background = background2;
	    this.locked = locked2;
	    this.rowSpan = rowSpan2;
	    this.columnSpan = columnSpan2;
	    
	    this.formatString = formatString;
	    this.formatIndex = formatIndex;
	    
	    
	    this.hashCode = hashCode();
    }
	
	public int getId() {
	    return synchronizationId;
	}
	
	public int getStyleId() {
	    return hashCode();
	}

    @Override
    public void accept(SpreadsheetVisitor v) {
        
    }

    @Override
    public Optional<SpreadsheetStyle> getParent() {
        return Optional.empty();
    }

    @Override
    public Collection<SpreadsheetStyle> getSpreadsheetChildren() {
        return Collections.emptyList();
    }

    @Override
    public void remove(SpreadsheetStyle child) {
        
    }

    @Override
    public String getName() {
        return "style";
    }

    @Override
    public Map<?, ?> getChildren() {
        return Collections.emptyMap();
    }

    @Override
    public Map<?, ?> getProperties() {
        return Collections.emptyMap();
    }

    @Override
    public int hashCode() {
        if (hashCode != 0)
            return hashCode;
        
        final int prime = 31;
        int result = 1;
        result = prime * result + align;
        result = prime * result + ((formatString == null) ? 0 : formatString.hashCode());
        result = prime * result + ((background == null) ? 0 : background.hashCode());
        result = prime * result + border;
        result = prime * result + formatIndex;
        result = prime * result + columnSpan;
        result = prime * result + ((font == null) ? 0 : font.hashCode());
        result = prime * result + ((foreground == null) ? 0 : foreground.hashCode());
        result = prime * result + (locked ? 1231 : 1237);
        result = prime * result + rowSpan;
        
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        SpreadsheetStyle other = (SpreadsheetStyle) obj;
        if (align != other.align)
            return false;
        if (background == null) {
            if (other.background != null)
                return false;
        } else if (!background.equals(other.background))
            return false;
        if (border != other.border)
            return false;
        if (columnSpan != other.columnSpan)
            return false;
        if (font == null) {
            if (other.font != null)
                return false;
        } else if (!font.equals(other.font))
            return false;
        if (foreground == null) {
            if (other.foreground != null)
                return false;
        } else if (!foreground.equals(other.foreground))
            return false;
        if (locked != other.locked)
            return false;
        if (rowSpan != other.rowSpan)
            return false;
        if (synchronizationId != other.synchronizationId)
            return false;
        if (formatIndex != other.formatIndex)
            return false;
        if (formatString == null) {
            if (other.formatString != null)
                return false;
        } else if (!formatString.equals(other.formatString))
            return false;
        return true;
    }
    
    public static SpreadsheetStyleBuilder newInstace() {
        return new SpreadsheetStyleBuilder();
    }
    
    public static SpreadsheetStyle empty() {
        return EMPTY;
    }
    
    public static class SpreadsheetStyleBuilder {
        
        private String name;
        private RGB.Integer foreground;
        private RGB.Integer background;
        private int border;
        private int align;
        private Font font;
        private boolean locked;
        private int rowSpan = 1;
        private int columnSpan = 1;
        private String formatString;
        private short formatIndex;

        private SpreadsheetStyleBuilder() {}
        
        public SpreadsheetStyleBuilder name(String name) {
            this.name = name;
            return this;
        }
        
        public SpreadsheetStyleBuilder foreground(RGB.Integer foreground) {
            this.foreground = foreground;
            return this;
        }
        
        public SpreadsheetStyleBuilder background(RGB.Integer background) {
            this.background = background;
            return this;
        }
        
        public SpreadsheetStyleBuilder border(Integer border) {
            this.border = border == null ? 0 : border;
            return this;
        }
        
        public SpreadsheetStyleBuilder align(Integer align) {
            this.align = align == null ? 0 : align;
            return this;
        }
        
        public SpreadsheetStyleBuilder font(Font font) {
            this.font = font;
            return this;
        }
        
        public SpreadsheetStyleBuilder locked(boolean locked) {
            this.locked = locked;
            return this;
        }
        
        public SpreadsheetStyleBuilder rowSpan(int rowSpan) {
            this.rowSpan = rowSpan;
            return this;
        }
        
        public SpreadsheetStyleBuilder font(int columnSpan) {
            this.columnSpan = columnSpan;
            return this;
        }
        
        public SpreadsheetStyle build() {
            SpreadsheetStyle style = new SpreadsheetStyle(name, border, align, font, foreground, background, locked, rowSpan, columnSpan, formatString, formatIndex);
            return style;
        }

        public SpreadsheetStyleBuilder formatString(String formatString) {
            this.formatString = formatString;
            return this;
        }

        public SpreadsheetStyleBuilder formatIndex(short formatIndex) {
            this.formatIndex = formatIndex;
            return this;
        }

        public SpreadsheetStyleBuilder columnSpan(int columnSpan2) {
            this.columnSpan = columnSpan2;
            return this;
        }
    }

    public void setSynchronizationId(int newId) {
        this.synchronizationId = newId;
    }
    
}
