package org.simantics.spreadsheet.graph;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.scl.runtime.function.Function;
import org.simantics.spreadsheet.resource.SpreadsheetResource;

public class Sources extends VariableRead<Map<String,Variable>> {

	public Sources(Variable variable) {
		super(variable);
	}

	@Override
	public Map<String,Variable> perform(ReadGraph graph) throws DatabaseException {
		
		SpreadsheetResource SHEET = SpreadsheetResource.getInstance(graph);
		Instances query = graph.adapt(SHEET.SourceContribution, Instances.class);
		Resource indexRoot = variable.getIndexRoot(graph);
		if(indexRoot == null) return Collections.emptyMap();
		
		Map<String,Variable> result = new HashMap<String,Variable>();
		for(Resource source : query.find(graph, indexRoot)) {

			Variable sv = Variables.getVariable(graph, source);
			@SuppressWarnings("rawtypes")
			Function f = sv.getPropertyValue(graph, SHEET.SourceContribution_function);
			List<Variable> in = Simantics.<List<Variable>>applySCLRead(graph, f, variable.getRepresents(graph));
			for(Variable var : in) {
				Function f2 = sv.getPropertyValue(graph, SHEET.SourceContribution_labeler);
				String key = Simantics.<String>applySCLRead(graph, f2, var);
				result.put(key, var);
			}
		}
		return result;
	}
	
}
