/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.spreadsheet.graph;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.common.procedure.adapter.AsyncListenerSupport;
import org.simantics.db.common.procedure.adapter.ListenerSupport;
import org.simantics.db.common.procedure.adapter.SyncListenerSupport;
import org.simantics.db.common.processor.MergingDelayedWriteProcessor;
import org.simantics.db.common.processor.MergingWriteOnlyProcessor;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.spreadsheet.Adaptable;
import org.simantics.spreadsheet.CellEditor;
import org.simantics.ui.SimanticsUI;

public class GraphBackend implements Adaptable, ListenerSupport, AsyncListenerSupport, SyncListenerSupport {

	final private RequestProcessor processor;

	final private VirtualGraph virtualGraph;

	private Resource model;
//	private Resource spreadsheet;
//	private Variable sheet;
//	private ModelCellManager creator;
	private CellEditor editor;
	private boolean disposed = false;

	final private MergingDelayedWriteProcessor delayedMerger;
	final private MergingWriteOnlyProcessor writeOnlyMerger;
	
	public GraphBackend(RequestProcessor processor, VirtualGraph virtualGraph) {
		this.processor = processor;
		this.virtualGraph = virtualGraph;
		delayedMerger = new MergingDelayedWriteProcessor(SimanticsUI.getSessionContext().getSession(), 5);
		writeOnlyMerger = new MergingWriteOnlyProcessor(SimanticsUI.getSessionContext().getSession(), virtualGraph, 5);
	}
	
	public RequestProcessor getModifier() {
		return delayedMerger;
	}

	public RequestProcessor getWriteOnlyModifier() {
		return writeOnlyMerger;
	}

	public void load(RequestProcessor proc, final Resource model, final Variable sheet) throws DatabaseException {

//		final ITask task = ThreadLogger.getInstance().begin("GraphBackend.load");
//		
//		this.model = model;
//
//		processor.asyncRequest(new ReadRequest() {
//
//			@Override
//			public void run(ReadGraph graph) throws DatabaseException {
//
//				Layer0 l0 = Layer0.getInstance(graph);
//
//				SpreadsheetResource sr = SpreadsheetResource.getInstance(graph);
//
//				final Resource realization = sheet.getInterface(graph, Resource.class);
//				Resource config = graph.getPossibleObject(realization, L0X.Represents);
//
//				// TODO : remove this and make the request persistent
//				processor.asyncRequest(new Rows(config), new CacheListener<RowsColumnsIndex>(GraphBackend.this));
//
//				creator = new DefaultCellCreator(processor, config);
//				editor = new DefaultCellEditor(processor, config);
//
//				graph.forObjectSet(config, sr.HasCell, new AsyncSetListenerDelegate<Resource>(GraphBackend.this) {
//
//					@Override
//					public void add(AsyncReadGraph graph, final Resource cellResource) {
//
//						graph.forAdapted(cellResource, ServerCell.class, new ResourceAsyncListenerDelegate<ServerCell>(cellResource, GraphBackend.this) {
//
//							@Override
//							public void execute(AsyncReadGraph graph, final ServerCell cell) {
//
//								cell.register(graph.getSession(), delayedMerger, cellResource);
//
//								graph.getSession().asyncRequest(new WriteRequest(virtualGraph) {
//
//									@Override
//									public void perform(WriteGraph graph) throws DatabaseException {
//
//										Layer0 L0 = Layer0.getInstance(graph);
//										SpreadsheetResource sr = SpreadsheetResource.getInstance(graph);
//
//										Map<Resource, Resource> map = graph.syncRequest(new MappedParts(realization));
//										Resource resource = map.get(cellResource);
//										Resource realizationType = graph.syncRequest(new RealizationType(cellResource, sr.Realization));
//
//										if(resource == null) {
//											resource = graph.newResource();
//											graph.claim(resource, L0.InstanceOf, null, realizationType);
//											graph.claim(resource, L0X.Represents, null, cellResource);
//											graph.addLiteral(resource, sr.Label, sr.LabelOf, L0.String, "", Bindings.STRING );
//											graph.addLiteral(resource, sr.Content, sr.ContentOf, L0.String, "", Bindings.STRING );
//											graph.claim(realization, L0.ConsistsOf, L0.PartOf, resource);
//										}
//
//										final AdaptionService service = graph.peekService(AdaptionService.class);
//
//										class Modifier implements ResourceAdapter<StringModifier> {
//
//											public void adapt(AsyncReadGraph graph, Resource source, Resource r, AsyncProcedure<StringModifier> procedure) {
//
//												procedure.execute(graph, new StringModifier() {
//
//													@Override
//													public String isValid(String newValue) {
//														return null;
//													}
//
//													@Override
//													public void modify(WriteGraph graph, String value) throws DatabaseException {
//
//														StringModifier modifier = graph.adapt(cellResource, StringModifier.class);
//														modifier.modify(graph, value);
//
//													}
//
//												});
//
//											}
//
//										};
//
//										service.addInstanceAdapter(resource, StringModifier.class, new Modifier());
//
//										cell.listen(GraphBackend.this, graph, resource);
//
//									}
//
//								});
//
//							}
//
//						});
//
//
//					}
//
//					@Override
//					public void remove(AsyncReadGraph graph, final Resource cellResource) {
//
//					}
//
//				});
//				
//				task.finish();
//
//			}
//
//		});

	}

	@Override
	public <T> T getAdapter(Class<T> clazz) {

/*		if(ModelCellManager.class == clazz) return (T)creator;
		else if(CellEditor.class == clazz) return (T)editor;
		else*/ return null;

	}

	@Override
	public void exception(Throwable t) {
		t.printStackTrace();
	}

	@Override
	public boolean isDisposed() {
		return disposed;
	}

	@Override
	public void exception(AsyncReadGraph graph, Throwable t) {
		t.printStackTrace();
	}

	@Override
	public void exception(ReadGraph graph, Throwable t) {
		t.printStackTrace();
	}

	public VirtualGraph getVirtualGraph() {
		return virtualGraph;
	}

	public Resource getModel() {
		return model;
	}
	
	public void dispose() {
		disposed = true;
	}

}
