/*******************************************************************************
 * Copyright (c) 2015 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.internal.startup;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.PlatformException;
import org.simantics.internal.Activator;
import org.simantics.startup.IStartup;

/**
 * @author Tuukka Lehtonen
 */
public class StartupExtensions {

    /**
     * @return
     */
    public static StartupExtension[] getAllStartupExtensions() {
        return Activator.getDefault().getStartupRegistry().getExtensions();
    }

    /**
     * Consults all {@link IStartup} extensions retrieved from
     * {@link #getAllStartupExtensions()} by invoking their
     * {@link IStartup#preStartup()} method.
     * 
     * @throws PlatformException
     */
    public static void consultStartupExtensions() throws PlatformException {
        for (StartupExtension ext : getAllStartupExtensions()) {
            try {
                ext.newInstance().preStartup();
            } catch (CoreException ex) {
                Activator.getDefault().getLog().log(
                        new Status(IStatus.ERROR, Activator.PLUGIN_ID,
                                "Failed to instantiate startup extension class "
                                        + ext.getClassName(), ex));
            }
        }
    }

}
