/*******************************************************************************
 * Copyright (c) 2015 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.internal.startup;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.simantics.startup.IStartup;

/**
 * @author Tuukka Lehtonen
 */
public class StartupExtension {

    public static final String CLASS = "class";

    // For access to createExecutableExtension(String).
    private final IConfigurationElement configurationElement;

    public StartupExtension(IConfigurationElement ce) {
        this.configurationElement = ce;
    }

    public String getClassName() {
        return configurationElement.getAttribute(CLASS);
    }

    public IStartup newInstance() throws CoreException {
        return (IStartup) configurationElement.createExecutableExtension(CLASS);
    }

    @Override
    public String toString() {
        return super.toString() + " [contributor=" + configurationElement.getContributor().getName() + "]";
    }

}